package org.modellwerkstatt.fx8forms.delegates;

/*Generated by MPS */

import javafx.scene.control.TextField;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import javafx.geometry.Pos;
import javafx.scene.input.MouseEvent;
import javafx.event.EventHandler;

public class DatePatternField extends TextField {
  private String pattern = "__.__.__";
  private int patternLength = 8;
  private char divisionChar = '.';
  private char[] replacementsChars = {','};


  private IDataUxDelegate delegate;


  public DatePatternField() {
    super();
    init();
  }

  public DatePatternField(String ptrn, char divChar, char[] rplcmntChars) {
    super();
    pattern = ptrn;
    patternLength = ptrn.length();
    divisionChar = divChar;
    replacementsChars = rplcmntChars;
    init();
  }

  public void init() {
    this.setMinHeight(FX8TextEditor.DELEGATE_EDITOR_MINHEIGH);
    this.setAlignment(Pos.CENTER_LEFT);

    this.addEventFilter(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>() {
      @Override
      public void handle(MouseEvent moEvent) {
        DatePatternField.this.selectAll();
      }
    });
    this.setPromptText(pattern);
  }



  @Override
  public void replaceText(int start, int end, String text) {
    // also for copy paste, not just for single char.
    for (char c : replacementsChars) {
      if (text.indexOf(c) >= 0) {
        text = text.replace(c, divisionChar);
      }
    }

    super.replaceText(start, end, text);

    if (text.length() == 1 && this.isOnlyPatternChars(text)) {
      // single key, user just entring date
      // ok, adjust cursor. a number or . was used ..
      start = start + 1;

      // let start alone, but replace end ..
      if (start < patternLength) {
        if (start >= getText().length()) {
          start = getText().length();
        }
        setText(getText().substring(0, start) + pattern.substring(start));

        if (getText().charAt(start) == divisionChar) {
          start += 1;
        }
        positionCaret(start);

      } else {
        // okay, clear field and put pattern into place
        start = getText().length();
        if (start >= patternLength) {
          start = patternLength;
        }
        setText(getText().substring(0, start));
        selectAll();

      }

    } else if ("".equals(text)) {
      // backspace or entf key. presumably?
      int currentCaretPosition = this.getCaretPosition();
      if (start < patternLength) {
        setText(getText().substring(0, start) + pattern.substring(start));
        positionCaret(currentCaretPosition);

      } else {
        start = patternLength;
        setText(getText().substring(0, start));
        selectAll();
      }

    } else {
      // copy paste activity.
      if (text.length() >= patternLength) {
        setText(text.substring(0, patternLength));
        selectAll();
      } else {
        setText(text + pattern.substring(text.length()));
        positionCaret(text.length());
      }
    }

    if (delegate != null) {
      delegate.isInputValid();
    }
  }

  public String getTextOrEmpty() {
    String text = this.getText();
    if (pattern.equals(text)) {
      return "";
    }
    return text;
  }

  public boolean isOnlyPatternChars(String st) {
    for (int i = 0; i < st.length(); i++) {
      if (!(st.charAt(i) == divisionChar || Character.isDigit(st.charAt(i)))) {
        return false;
      }
    }
    return true;
  }


  public void setDelegate(IDataUxDelegate dlgt) {
    delegate = dlgt;
  }
}
