package org.modellwerkstatt.fx8forms.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.scene.control.TextArea;
import javafx.scene.control.Label;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import javafx.geometry.Pos;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Clipboard;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import javafx.scene.control.Tooltip;

public class FX8AreaEditor extends FX8EditorWithOptions implements IToolkit_TextEditor, EventHandler<KeyEvent> {
  public static int aproxEditHeigfht = 19;

  protected TextArea textArea;
  protected Label label;
  protected IDataUxDelegate delegate;
  protected boolean notifyDelegateOnKeyPress;


  public FX8AreaEditor(int numLines) {
    notifyDelegateOnKeyPress = false;

    label = new Label();
    label.getStyleClass().add("delegateLabel");
    label.setLabelFor(textArea);
    label.setAlignment(Pos.TOP_RIGHT);

    textArea = new TextArea();
    textArea.setWrapText(true);
    textArea.getStyleClass().add("delegateControl");
    textArea.setPrefHeight(aproxEditHeigfht * numLines);
    textArea.setMinHeight(aproxEditHeigfht * numLines);

    label.setOnMouseClicked(new EventHandler<MouseEvent>() {
      @Override
      public void handle(MouseEvent event) {
        if (event.getClickCount() == 2 && event.getButton().equals(MouseButton.PRIMARY)) {
          ClipboardContent allContent = new ClipboardContent();
          allContent.putString(textArea.getText());
          Clipboard.getSystemClipboard().setContent(allContent);
        }
      }
    });

    textArea.setOnKeyReleased(new EventHandler<KeyEvent>() {
      public void handle(KeyEvent p0) {
        // check for Euro conversion
        if (!(textArea.isDisabled()) && textArea.getText().contains("€")) {
          int pos = textArea.getCaretPosition();
          textArea.setText(textArea.getText().replace("€", "EUR"));
          textArea.positionCaret(pos + 2);
        }

        if (notifyDelegateOnKeyPress) {
          if (delegate.isInputValid() == null) {
            delegate.keyReleasedEvent();
          }
        }
      }
    });

    textArea.addEventFilter(KeyEvent.KEY_PRESSED, this);
  }

  public void handle(KeyEvent event) {
    if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(event.getCode().getName(), false) && textArea.getScene() != null) {
      textArea.getScene().getOnKeyPressed().handle(event);
    }
  }

  public void setDelegate(IDataUxDelegate dlgt) {
    delegate = dlgt;
  }

  public void enableKeyReleaseEvents() {
    notifyDelegateOnKeyPress = true;
  }

  public void setLabelTooltip(String t) {
    label.setTooltip(new Tooltip(t));
  }

  public void setValidationErrorText(String text) {

    if (text == null || text.trim().equals("")) {
      // ToDO: Known JAVAFX Bug..
      textArea.setStyle("-fx-border-color: -error-red; -fx-border-width: 0;");
      textArea.setTooltip(null);

    } else {
      textArea.setStyle("-fx-border-color: -error-red; -fx-border-width: 1;");
      textArea.setTooltip(new Tooltip(text));
    }
  }

  public void setLabel(String labelString) {
    label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
    label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
  }

  public void setEditorPrompt(String promptText) {
    textArea.setPromptText(promptText);
  }
  public void setEnabled(boolean enabled) {

    // workaround for disabled scrollbar when using setDisabled
    textArea.setEditable(enabled);
    if (!(enabled)) {
      textArea.setStyle("-fx-text-fill: -lightdark;");
    } else {
      textArea.setStyle("-fx-text-fill:  -fx-accent;");
    }

  }


  public void setText(String text) {
    textArea.setText(text);
  }
  public String getText() {
    return textArea.getText();
  }

  public void setIssuesUpdateConclusion() {
    throw new RuntimeException("Update Conclusion not supported for FX8AreaEditor..");
  }

  public Object getEditor() {
    return textArea;
  }
  public Object getLabel() {
    return label;
  }
  public Object getRightPartComponent() {
    return getEditor();
  }
  @Override
  public void newObjectBound() {
  }
  public void gcClear() {
    textArea.setOnKeyReleased(null);
    textArea.removeEventFilter(KeyEvent.KEY_PRESSED, this);
  }
}
