package org.modellwerkstatt.fx8forms.delegates;

/*Generated by MPS */

import javafx.scene.layout.HBox;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import javafx.scene.control.Label;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.geometry.Pos;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Clipboard;
import javafx.scene.control.Tooltip;
import javafx.scene.control.Control;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import javafx.scene.input.KeyCode;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;
import javafx.event.ActionEvent;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;

public class FX8DateAndTimeEditor extends HBox implements IToolkit_DateOrTimeEditor, EventHandler<KeyEvent> {
  private IDataUxDelegate delegate;
  protected Label label;
  private DatePatternField dateField;
  private DatePatternField timeField;
  private Node complexRightPart;
  private Button updateConclusionButton;

  protected boolean issueUpdateConclusion;
  protected String lastTextIssuedUpdate;



  public FX8DateAndTimeEditor() {
    // Delegate written on 11th of July 2016

    issueUpdateConclusion = false;
    lastTextIssuedUpdate = null;

    dateField = new DatePatternField();
    timeField = new DatePatternField("__:__", ':', new char[]{',', '.'});

    label = new Label();
    label.getStyleClass().add("delegateLabel");
    label.setLabelFor(this);
    label.setAlignment(Pos.TOP_RIGHT);

    this.getChildren().addAll(dateField, timeField);
    complexRightPart = this;

    label.setOnMouseClicked(new EventHandler<MouseEvent>() {
      @Override
      public void handle(MouseEvent event) {
        if (event.getClickCount() == 2 && event.getButton().equals(MouseButton.PRIMARY)) {
          ClipboardContent allContent = new ClipboardContent();
          allContent.putString(FX8DateAndTimeEditor.this.getText());
          Clipboard.getSystemClipboard().setContent(allContent);
        }
      }
    });


    dateField.addEventFilter(KeyEvent.KEY_PRESSED, this);
    timeField.addEventFilter(KeyEvent.KEY_PRESSED, this);

  }


  public void enableKeyReleaseEvents() {
    throw new RuntimeException("KeyReleaseEvents are not supported for FX8DateTimeEditor.");
  }
  public void setValidationErrorText(String text) {
    if (text == null || text.trim().equals("")) {
      // ToDO: Known JAVAFX Bug..
      this.setStyle("-fx-border-color: -error-red; -fx-border-width: 0;");
      dateField.setTooltip(null);
      timeField.setTooltip(null);

    } else {
      this.setStyle("-fx-border-color: -error-red; -fx-border-width: 1;");
      dateField.setTooltip(new Tooltip(text));
      timeField.setTooltip(new Tooltip(text));

    }
  }


  @Override
  public void newObjectBound() {
    lastTextIssuedUpdate = null;
  }

  public void setText(String text) {
    if ("".equals(text)) {
      dateField.setText("");
      timeField.setText("");
    } else {
      // check what comes first. : or .
      int splitPoint = text.lastIndexOf(" ");
      String date = text.substring(0, splitPoint);
      String time = text.substring(splitPoint + 1);
      dateField.setText(date);
      timeField.setText(time);
    }
  }
  public String getText() {
    // in case date and timefield are empty - whole string is empty
    return (dateField.getTextOrEmpty() + " " + timeField.getTextOrEmpty()).trim();
  }

  public void handle(KeyEvent event) {
    Control sender = ((Control) event.getSource());

    if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(event.getCode().getName(), false) && dateField.getScene() != null) {
      dateField.getScene().getOnKeyPressed().handle(event);

    } else if ((event.getCode() == KeyCode.TAB && !(event.isShiftDown())) || event.getCode() == KeyCode.ENTER) {
      event.consume();

      if (sender.equals(dateField)) {
        // dateField, just move to time field.
        FX8TraversalHelper.traverseNext(sender);


      } else {
        // this is the timeField then..
        if (issueUpdateConclusion && !(getText().equals(lastTextIssuedUpdate)) && !(dateField.isDisabled())) {
          if (delegate.isInputValid() == null) {
            lastTextIssuedUpdate = getText();
            delegate.issueUpdateConclusionAfterContentChange();
          }

        } else {
          FX8TraversalHelper.traverseNext(sender);

        }

      }



    } else if ((event.getCode() == KeyCode.TAB && event.isShiftDown())) {
      event.consume();

      FX8TraversalHelper.traversePrevious(sender);
    }


  }


  public void setIssuesUpdateConclusion() {
    updateConclusionButton = FX8TextEditor.createUpdateButton();
    updateConclusionButton.setOnAction(new EventHandler<ActionEvent>() {
      public void handle(ActionEvent p0) {
        if (delegate.isInputValid() == null) {
          lastTextIssuedUpdate = getText();
          delegate.issueUpdateConclusionAfterContentChange();
        }
      }
    });

    this.getChildren().add(updateConclusionButton);
    issueUpdateConclusion = true;
  }
  public void setLabelTooltip(String text) {
    label.setTooltip(new Tooltip(text));
  }

  public void setEditorPrompt(String promptText) {
    if (promptText.contains(" ")) {
      String[] splitted = promptText.trim().split("\\s+");
      dateField.setPromptText(splitted[0]);
      timeField.setPromptText(splitted[1]);
    }
  }
  public void setLabel(String labelString) {
    label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
    label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
  }
  public void setEnabled(boolean enabled) {
    dateField.setDisable(!(enabled));
    timeField.setDisable(!(enabled));
    if (updateConclusionButton != null) {
      updateConclusionButton.setDisable(!(enabled));
    }
  }
  public boolean isOnlyDateChars(String st) {
    for (int i = 0; i < st.length(); i++) {
      if (!(st.charAt(i) == '.' || Character.isDigit(st.charAt(i)))) {
        return false;
      }
    }
    return true;
  }
  public void setDelegate(IDataUxDelegate dlgt) {
    delegate = dlgt;
  }
  public Object getEditor() {
    return this;
  }
  public Object getLabel() {
    return label;
  }
  public Object getRightPartComponent() {
    return complexRightPart;
  }
  @Override
  public void requestFocus() {
    dateField.requestFocus();
  }

  @Override
  public void setOption(IToolkit_TextEditor.Option... option) {
  }
  @Override
  public void setFormatter(String format, String locale, int langIdx) {
    // formate in fx8 is static de __.__.__ __:__
  }
  public void gcClear() {

    dateField.removeEventFilter(KeyEvent.KEY_PRESSED, this);
    timeField.removeEventFilter(KeyEvent.KEY_PRESSED, this);


    dateField = null;
    timeField = null;
  }
}
