package org.modellwerkstatt.fx8forms.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import java.time.format.DateTimeFormatter;
import javafx.util.StringConverter;
import java.time.LocalDate;
import org.modellwerkstatt.dataux.runtime.delegates.LocalDateDelegate;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;
import javafx.geometry.Pos;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Clipboard;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.application.Platform;
import java.util.Locale;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import javafx.scene.input.KeyCode;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;
import javafx.scene.control.Tooltip;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;

public class FX8DatePicker implements IToolkit_DateOrTimeEditor, EventHandler<KeyEvent> {

  protected DatePicker datePicker;
  protected Label label;
  protected IDataUxDelegate delegate;
  protected EventHandler<KeyEvent> keyReleaseHandler;
  protected DateTimeFormatter javaUtilDateTimeFormatter;



  public FX8DatePicker() {
    datePicker = new DatePicker();
    datePicker.setConverter(new StringConverter<LocalDate>() {
      @Override
      public String toString(LocalDate p1) {
        return (p1 == null ? "" : javaUtilDateTimeFormatter.format(p1));
      }

      @Override
      public LocalDate fromString(String p1) {
        if (p1 == null || p1.equals("")) {
          return null;

        } else {
          LocalDate notAdjusted = LocalDate.parse(LocalDateDelegate.adjusDateDotInputText(p1), javaUtilDateTimeFormatter);
          LocalDate adjusted = notAdjusted.withYear(MoWareFormattersFactory.twoToFourDigitYear(notAdjusted.getYear()));
          return adjusted;
        }
      }
    });

    label = new Label();
    label.getStyleClass().add("delegateLabel");
    label.setLabelFor(datePicker);
    label.setAlignment(Pos.TOP_RIGHT);

    datePicker.setMinHeight(FX8TextEditor.DELEGATE_EDITOR_MINHEIGH);

    label.setOnMouseClicked(new EventHandler<MouseEvent>() {
      @Override
      public void handle(MouseEvent event) {
        if (event.getClickCount() == 2 && event.getButton().equals(MouseButton.PRIMARY)) {
          ClipboardContent allContent = new ClipboardContent();
          allContent.putString("" + datePicker.getValue());
          Clipboard.getSystemClipboard().setContent(allContent);
        }
      }
    });

    datePicker.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, this);
    datePicker.focusedProperty().addListener(new ChangeListener<Boolean>() {
      @Override
      public void changed(ObservableValue<? extends Boolean> p1, Boolean old, Boolean newFocus) {
        if (newFocus) {
          Platform.runLater(new Runnable() {
            @Override
            public void run() {
              datePicker.getEditor().selectAll();
            }
          });
        }
      }
    });
  }


  @Override
  public void setFormatter(String format, String locale, int langIdx) {
    javaUtilDateTimeFormatter = DateTimeFormatter.ofPattern(format, Locale.forLanguageTag(locale));
  }

  @Override
  public void handle(KeyEvent event) {

    if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(event.getCode().getName(), false) && datePicker.getScene() != null) {
      datePicker.getScene().getOnKeyPressed().handle(event);

    } else if ((event.getCode() == KeyCode.TAB && !(event.isShiftDown())) || event.getCode() == KeyCode.ENTER) {
      event.consume();
      FX8TraversalHelper.traverseNext(datePicker);

    } else if ((event.getCode() == KeyCode.TAB && event.isShiftDown())) {
      event.consume();
      FX8TraversalHelper.traversePrevious(datePicker);

    }
  }
  public void setDelegate(IDataUxDelegate dlgt) {
    delegate = dlgt;
  }

  @Override
  public void enableKeyReleaseEvents() {
  }

  public void setLabelTooltip(String t) {
    label.setTooltip(new Tooltip(t));
  }

  public void setValidationErrorText(String text) {

    if (text == null || text.trim().equals("")) {
      // Known JAVAFX Bug..
      datePicker.setStyle("-fx-border-color: -error-red; -fx-border-width: 0;");
      datePicker.setTooltip(null);

    } else {
      datePicker.setStyle("-fx-border-color: -error-red; -fx-border-width: 1;");
      datePicker.setTooltip(new Tooltip(text));
    }
  }

  public void setLabel(String labelString) {
    label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
    label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
  }

  public void setEnabled(boolean enabled) {
    datePicker.setDisable(!(enabled));
  }
  @Override
  public void newObjectBound() {
  }
  public void setText(String text) {
    if (noValue(text)) {
      datePicker.setValue(null);
    } else {
      datePicker.getEditor().setText(text);
      LocalDate notAdjusted = LocalDate.parse(text, javaUtilDateTimeFormatter);
      LocalDate adjusted = notAdjusted.withYear(MoWareFormattersFactory.twoToFourDigitYear(notAdjusted.getYear()));
      datePicker.setValue(adjusted);
    }
  }

  public String getText() {
    LocalDate dateFromPicker = datePicker.getValue();
    String textFieldText = LocalDateDelegate.adjusDateDotInputText(datePicker.getEditor().getText().trim());

    if (dateFromPicker == null) {
      return textFieldText;
    }
    String pickerFieldText = javaUtilDateTimeFormatter.format(dateFromPicker);

    if (!(textFieldText.equals(pickerFieldText))) {
      datePicker.setValue(null);
      datePicker.getEditor().setText(textFieldText);
      return textFieldText;
    }
    return pickerFieldText;
  }

  private boolean noValue(String txt) {
    return txt == null || "".equals(txt.trim());
  }

  @Override
  public void setIssuesUpdateConclusion() {
  }
  public Object getEditor() {
    return datePicker;
  }
  public Object getLabel() {
    return label;
  }
  public Object getRightPartComponent() {
    return datePicker;
  }

  public void setEditorPrompt(String promptText) {
    datePicker.setPromptText(promptText);
  }

  @Override
  public void setOption(IToolkit_TextEditor.Option... option) {
  }
  public void gcClear() {
    datePicker.getEditor().removeEventFilter(KeyEvent.KEY_PRESSED, this);
  }

}
