package org.modellwerkstatt.fx8forms.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ImageEditor;
import javafx.scene.image.ImageView;
import javafx.scene.control.Label;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import javafx.geometry.Pos;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import java.io.FileInputStream;
import org.modellwerkstatt.fx8forms.windows.FX8CmdUiBasis;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;

public class FX8ImageEditor implements IToolkit_ImageEditor {
  private ImageView imageView;
  protected Label label;
  protected IDataUxDelegate delegate;

  protected int pxlToSubstractY = 200;
  protected int pxlToSubstractX = 200;

  protected double imageHeight;
  protected double imageWidth;

  public FX8ImageEditor() {
    imageView = new ImageView();

    label = new Label();
    label.getStyleClass().add("delegateLabel");
    label.setLabelFor(imageView);
    label.setAlignment(Pos.TOP_RIGHT);
  }



  public void setDelegate(IDataUxDelegate dlgt) {
    delegate = dlgt;
  }
  public void enableKeyReleaseEvents() {
  }
  public void setLabelTooltip(String text) {
    label.setTooltip(new Tooltip(text));
  }
  public void setValidationErrorText(String text) {
  }
  public void setLabel(String text) {
    label.setText(FX8TextEditor.getLabelTextAdjustColon(text));
    label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(text));
  }
  public void setEnabled(boolean enabled) {
  }
  @Override
  public void newObjectBound() {
  }
  public void setText(String text) {
    Image image;
    if (text == null || text.trim().equals("")) {
      return;
    }

    try {
      FileInputStream in = new FileInputStream(text);
      image = new Image(in);
      imageView.setImage(image);
      imageView.setPreserveRatio(true);
      in.close();

      // small must fit?
      imageHeight = image.getHeight();
      imageWidth = image.getWidth();

    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
  }

  public double getPreservedImageWidthToHeight(double toHeight) {
    return toHeight / imageHeight * imageWidth;
  }


  public void adjustImageSize() {

    if (imageView.getScene() == null) {
      FX8CmdUiBasis.runRealyLater(new Runnable() {
        @Override
        public void run() {
          adjustImageSize();
        }
      });

    } else {
      double spaceWidth = imageView.getScene().getWidth() - pxlToSubstractX;
      double spaceHeight = imageView.getScene().getHeight() - pxlToSubstractY;

      double neededWidth = getPreservedImageWidthToHeight(spaceHeight);


      if (neededWidth > spaceWidth) {
        imageView.setFitWidth(spaceWidth);
      } else {
        imageView.setFitHeight(spaceHeight);
      }
    }


  }

  public String getText() {
    return "";
  }
  public Object getEditor() {
    return imageView;
  }
  public Object getLabel() {
    return label;
  }
  public Object getRightPartComponent() {
    return getEditor();
  }
  public void setIssuesUpdateConclusion() {
  }
  public void setEditorPrompt(String promptText) {
    String[] xySplit = promptText.split(",");
    String xVal = xySplit[0].trim();
    String yVal = xySplit[1].trim();

    this.pxlToSubstractX = Integer.valueOf(xVal);
    this.pxlToSubstractY = Integer.valueOf(yVal);
  }
  public void setSubtractWidth(int pxl) {
    this.pxlToSubstractX = pxl;
  }
  public void setSubtractHeight(int pxl) {
    this.pxlToSubstractY = pxl;
  }
  @Override
  public void setOption(IToolkit_TextEditor.Option... option) {
  }
  public void gcClear() {
  }
}
