package org.modellwerkstatt.fx8forms.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.scene.control.TextField;
import javafx.scene.control.Button;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import javafx.geometry.Pos;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Clipboard;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import javafx.scene.input.KeyCode;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import org.modellwerkstatt.fx8forms.windows.FX8UiFactory;
import javafx.scene.image.ImageView;
import javafx.geometry.Insets;
import javafx.scene.layout.HBox;
import javafx.event.ActionEvent;
import javafx.scene.layout.Priority;
import javafx.scene.text.Text;

public class FX8TextEditor extends FX8EditorWithOptions implements IToolkit_TextEditor, EventHandler<KeyEvent> {
  public static final int DELEGATE_EDITOR_MINHEIGH = 26;


  protected TextField textField;
  protected Button updateButton;
  protected Node complexRightPart;

  protected Label label;
  protected IDataUxDelegate delegate;
  protected boolean notifyDelegateOnKeyPress;

  protected boolean issueUpdateConclusion;
  protected String lastTextIssuedUpdate;

  protected EventHandler<KeyEvent> keyReleaseHandler;



  public FX8TextEditor(boolean dateEditor) {
    notifyDelegateOnKeyPress = false;
    issueUpdateConclusion = false;
    lastTextIssuedUpdate = null;

    label = new Label();
    label.getStyleClass().add("delegateLabel");
    label.setLabelFor(textField);
    label.setAlignment(Pos.TOP_RIGHT);

    if (!(dateEditor)) {
      textField = new TextField();
      textField.getStyleClass().add("delegateControl");
      textField.setMinHeight(DELEGATE_EDITOR_MINHEIGH);
    } else {
      textField = new DatePatternField();
      textField.getStyleClass().add("delegateControl");
      textField.setMinHeight(DELEGATE_EDITOR_MINHEIGH);
    }

    complexRightPart = textField;
    textField.setMinWidth(100);

    label.setOnMouseClicked(new EventHandler<MouseEvent>() {
      @Override
      public void handle(MouseEvent event) {
        if (event.getClickCount() == 2 && event.getButton().equals(MouseButton.PRIMARY)) {
          ClipboardContent allContent = new ClipboardContent();
          allContent.putString(textField.getText());
          Clipboard.getSystemClipboard().setContent(allContent);
        }
      }
    });


    keyReleaseHandler = new EventHandler<KeyEvent>() {
      public void handle(KeyEvent p0) {

        // check for Euro conversion
        if (!(textField.isDisabled()) && textField.getText().contains("€")) {
          int pos = textField.getCaretPosition();
          textField.setText(textField.getText().replace("€", "EUR"));
          textField.positionCaret(pos + 2);
        }

        if (notifyDelegateOnKeyPress) {
          if (delegate.isInputValid() == null) {
            delegate.keyReleasedEvent();
          }
        }
      }
    };

    textField.setOnKeyReleased(keyReleaseHandler);
    textField.addEventFilter(KeyEvent.KEY_PRESSED, this);
  }

  public void handle(KeyEvent event) {

    if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(event.getCode().getName(), false) && textField.getScene() != null) {
      textField.getScene().getOnKeyPressed().handle(event);

    } else if ((event.getCode() == KeyCode.TAB && !(event.isShiftDown())) || event.getCode() == KeyCode.ENTER) {
      event.consume();


      if (issueUpdateConclusion && !(textField.getText().equals(lastTextIssuedUpdate))) {
        if (delegate.isInputValid() == null && !(textField.isDisabled())) {
          lastTextIssuedUpdate = textField.getText();
          delegate.issueUpdateConclusionAfterContentChange();
        }

      } else {
        FX8TraversalHelper.traverseNext(textField);

      }


    } else if ((event.getCode() == KeyCode.TAB && event.isShiftDown())) {
      event.consume();
      FX8TraversalHelper.traversePrevious(textField);

    }


  }

  public void setDelegate(IDataUxDelegate dlgt) {
    delegate = dlgt;
    if (textField instanceof DatePatternField) {
      ((DatePatternField) textField).setDelegate(delegate);
    }
  }

  public void enableKeyReleaseEvents() {
    notifyDelegateOnKeyPress = true;
  }

  public void setLabelTooltip(String t) {
    label.setTooltip(new Tooltip(t));
  }

  public void setValidationErrorText(String text) {

    if (text == null || text.trim().equals("")) {
      // Known JAVAFX Bug..
      textField.setStyle("-fx-border-color: -error-red; -fx-border-width: 0;");
      textField.setTooltip(null);

    } else {
      textField.setStyle("-fx-border-color: -error-red; -fx-border-width: 1;");
      textField.setTooltip(new Tooltip(text));
    }
  }

  public void setLabel(String labelString) {
    label.setText(getLabelTextAdjustColon(labelString));
    label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
  }

  public void setEnabled(boolean enabled) {
    if (updateButton != null) {
      updateButton.setDisable(!(enabled));
    }
    textField.setDisable(!(enabled));
  }
  @Override
  public void newObjectBound() {
    lastTextIssuedUpdate = null;
  }
  public void setText(String text) {
    textField.setText(text);
  }
  public String getText() {
    if (textField instanceof DatePatternField) {
      return ((DatePatternField) textField).getTextOrEmpty();
    }
    return textField.getText();
  }

  public static Button createUpdateButton() {
    Image img = new Image(FX8UiFactory.getImage("autorenew"));
    Button btn = new Button();
    btn.setFocusTraversable(false);
    btn.setGraphic(new ImageView(img));
    btn.setPadding(new Insets(4, 5, 4, 5));
    return btn;
  }
  public void setIssuesUpdateConclusion() {
    HBox box = new HBox();
    updateButton = createUpdateButton();
    updateButton.setOnAction(new EventHandler<ActionEvent>() {
      public void handle(ActionEvent p0) {
        if (delegate.isInputValid() == null) {
          lastTextIssuedUpdate = textField.getText();
          delegate.issueUpdateConclusionAfterContentChange();
        }
      }
    });

    box.getChildren().addAll(textField, updateButton);
    HBox.setHgrow(textField, Priority.ALWAYS);
    complexRightPart = box;
    issueUpdateConclusion = true;

  }
  public Object getEditor() {
    return textField;
  }
  public Object getLabel() {
    return label;
  }
  public Object getRightPartComponent() {
    return complexRightPart;
  }

  public void setEditorPrompt(String promptText) {
    textField.setPromptText(promptText);
  }

  public void gcClear() {
    textField.setOnKeyReleased(null);
    textField.removeEventFilter(KeyEvent.KEY_PRESSED, this);
  }

  public static String getLabelTextAdjustColon(String label) {
    if (label.trim().equals("")) {
      return "";
    }
    return label + ": ";
  }
  public static double getLabelWidthWRKRND(String labelString) {
    double width;
    try {
      Text text = new Text(labelString + "XX");
      text.snapshot(null, null);
      width = text.getLayoutBounds().getWidth();

    } catch (Throwable t) {
      width = 100;
    }

    if (width > 100) {
      return width;

    } else {
      return 100;

    }
  }
}
