package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.layout.BorderPane;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_FormContainer;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.utils.LayoutConstraint;
import javafx.scene.Node;
import org.modellwerkstatt.dataux.runtime.core.FocusController;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import javafx.scene.layout.VBox;
import javafx.scene.layout.Priority;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import javafx.scene.control.SplitPane;

public class DEP_FX8FormContainer11<T> extends BorderPane implements IToolkit_FormContainer<T> {
  public static String formTitleLabel = "FX8FormTitleLabel";
  public static String formFlagLabel = "FX8FormFlagLabel";
  public static String formFlagBorder = "FX8FromFlagBorder";
  public static String formWarningLabel = "FX8FormWarningLabel";


  private FX8FlagBox titleLabel;

  private BorderPane topPane;
  private List<LayoutConstraint> rowConstraints;
  private List<LayoutConstraint> colConstraints;
  private List<FX8ColFormContainer> rows;

  private Node contentPane;
  private int curRow;
  private int curCol;

  private FX8ActionHBox actions;
  private FocusController focusController;
  private int adjustedDividerCnt = 0;


  public DEP_FX8FormContainer11() {
    super();
    this.getStyleClass().add("FX8FormContainer");
    focusController = new FocusController();

    rows = ListSequence.fromList(new ArrayList<FX8ColFormContainer>());
    curRow = -1;
    curCol = 0;

  }


  public void debug(String methodName) {
    System.err.println("\n\n" + methodName + " -- -- -- -- -- -- -- -- -- -- -- ");
    System.err.println("RowConstrains " + rowConstraints);
    System.err.println("ColConstrains " + colConstraints);
  }

  @Override
  public void skipFocus(int cmptToStartWith) {
    focusController.skipFocus(cmptToStartWith);
  }
  public void initTitle() {
    titleLabel = new FX8FlagBox();
    topPane = new BorderPane();
    topPane.setLeft(titleLabel);
    setTop(topPane);
  }

  public void setTitleText(String text) {
    // check if a title is installed at all ..
    if (getTop() == null) {
      initTitle();
    }
    titleLabel.setTitle(text);

  }
  public void setProblems(List<IOFXProblem> listOfProblems) {
    if (getTop() == null) {
      initTitle();
    }

    if (ListSequence.fromList(listOfProblems).count() == 0) {
      // clear flag action
      titleLabel.flag(listOfProblems);
      getCenter().getStyleClass().remove(formFlagBorder);
    } else {
      getCenter().getStyleClass().add(formFlagBorder);
      titleLabel.flag(listOfProblems);
    }

  }

  public void addMenuAndSetButtons(Menu folder) {
    if (getTop() == null) {
      initTitle();
    }

    // no context menu
    actions = new FX8ActionHBox(folder, null);
    topPane.setRight(actions);

  }


  public void loadList(List<T> objects, IOFXSelection<T> selection) {
  }
  public boolean selectionChanged(IOFXSelection<T> selection) {
    return false;
  }



  public void setLayoutConstraints(List<String> colConstraints, List<String> rowConstraints) {
    this.rowConstraints = ListSequence.fromList(new ArrayList<LayoutConstraint>());
    this.colConstraints = ListSequence.fromList(new ArrayList<LayoutConstraint>());
    ListSequence.fromList(rowConstraints).visitAll((it) -> ListSequence.fromList(DEP_FX8FormContainer11.this.rowConstraints).addElement(new LayoutConstraint(it)));
    ListSequence.fromList(colConstraints).visitAll((it) -> ListSequence.fromList(DEP_FX8FormContainer11.this.colConstraints).addElement(new LayoutConstraint(it)));

    final int totalRowWeight = LayoutConstraint.calcTotalWeight(this.rowConstraints);
    final int totalColWeight = LayoutConstraint.calcTotalWeight(this.colConstraints);
    ListSequence.fromList(this.rowConstraints).visitAll((it) -> it.setTotalWeight(totalRowWeight));
    ListSequence.fromList(this.colConstraints).visitAll((it) -> it.setTotalWeight(totalColWeight));

    // okay - use simply a VBox? In case more than one child is added
    // or use a split pane ?
    this.contentPane = new VBox();
    VBox.setVgrow(this.contentPane, Priority.ALWAYS);

    this.setCenter(this.contentPane);
  }
  public List<?> getHotKeysToRegister() {
    return null;
  }

  public void addChildren(IToolkit_Form child) {
    // okay, add it to the focus controller
    focusController.addChild(child);

    if (ListSequence.fromList(this.colConstraints).count() > 1) {
      // new row necessary ??
      if (curCol % ListSequence.fromList(this.colConstraints).count() == 0) {
        FX8ColFormContainer cfc = new FX8ColFormContainer(this.colConstraints);
        ListSequence.fromList(rows).addElement(cfc);
        ((VBox) contentPane).getChildren().add(cfc.getNode());
        VBox.setVgrow(cfc.getNode(), Priority.ALWAYS);

        curCol = 0;
        curRow++;
      }
      // use Grid ...
      ListSequence.fromList(rows).getElement(curRow).addChild((Node) child);
      VBox.setVgrow((Node) child, Priority.ALWAYS);

      curCol++;

    } else {
      // simply put it into the vbox..
      curRow++;

      ((VBox) contentPane).getChildren().add((Node) child);
      VBox.setVgrow((Node) child, Priority.ALWAYS);
    }
  }


  public void afterFullUiInitialized() {

    // and deliver forward ...
    focusController.afterFullUiInitialized();
    // depth first .. logo!
  }
  public Object myRequestFocus() {
    return focusController.myRequestFocus();
  }
  public void gcClear() {
    if (actions != null) {
      actions.gcClear();
      actions = null;
    }

    focusController.gcClear();
    // TODO: gcClear() on triggers only if triggers are not null_ !!
    actions = null;

    if (contentPane instanceof VBox) {
      ((VBox) contentPane).getChildren().clear();
    } else if (contentPane instanceof SplitPane) {
      ((SplitPane) contentPane).getItems().clear();
    }
    contentPane = null;
    this.setCenter(null);

  }


}
