package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.application.Application;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.objectflow.runtime.UserEnvironmentInformation;
import javafx.stage.Stage;
import org.modellwerkstatt.dataux.runtime.core.ApplicationMDI;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Tab;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import javafx.scene.Scene;
import javafx.application.Platform;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import javafx.event.EventHandler;
import javafx.stage.WindowEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.KeyCode;
import javafx.event.EventTarget;
import javafx.scene.control.TextField;
import org.modellwerkstatt.fx8forms.delegates.AutoCompletePopupField;
import javafx.scene.control.ComboBox;
import org.modellwerkstatt.fx8forms.delegates.DatePatternField;
import javafx.scene.control.TextArea;
import org.modellwerkstatt.dataux.runtime.core.LoginController;
import javafx.beans.value.ObservableValue;
import java.io.File;
import java.io.FileInputStream;
import javafx.scene.image.Image;
import com.sun.javafx.css.StyleManager;
import inputRuntimeTest.IConsLoader;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import javafx.event.ActionEvent;
import com.sun.javafx.runtime.VersionInfo;
import org.modellwerkstatt.dataux.runtime.genspecifications.TileAction;
import javafx.scene.control.TabPane;
import javafx.collections.ObservableList;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;
import javafx.concurrent.Task;
import org.modellwerkstatt.dataux.runtime.core.CloseCntrExInfoEvent;
import javafx.scene.control.MenuItem;
import org.modellwerkstatt.dataux.runtime.genspecifications.AbstractAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import javafx.scene.control.SeparatorMenuItem;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import java.awt.SplashScreen;

public class FX8Application extends Application implements IToolkit_MainWindow {
  private static final String FX8TABCONTENTSTYLECLASS = "FX8ModalTab";
  public static FX8UiFactory factory;

  private static IGenAppUiModule appBehaviour;
  private static UserEnvironmentInformation userEnv;

  private FX8MainBorder mainBorder;
  private Stage mainStage;
  private ApplicationMDI appController;
  private String appVersionInfo;
  private volatile Throwable throwToReport;
  private ChangeListener<Tab> tabChangeListener;
  private AppJmxRegistration jmxHelper;

  private boolean runsWithRider;
  private String systemName = "";

  public static boolean FX8_HOTKEY_NEEDS_CRTL(String keyName) {
    if (keyName != null && keyName.length() == 1) {
      return true;
    }
    return false;
  }
  public static boolean FX8_IS_HOTKEY_TO_FORWARD(String keyName, boolean isStatusComboBox) {
    if (keyName != null) {
      // F1 .. Fx
      if (keyName.length() >= 2 && keyName.charAt(0) == 'F') {
        return true;
      }
      //  - some other hotkey ??
      if (keyName.toUpperCase().equals("INSERT")) {
        return true;
      }
      if (keyName.toUpperCase().equals("DOWN") && !(isStatusComboBox)) {
        return true;
      }
      if (keyName.toUpperCase().equals("UP") && !(isStatusComboBox)) {
        return true;
      }
    }
    return false;
  }



  public void start(Stage stage) throws Exception {
    runsWithRider = false;
    mainStage = stage;
    Scene mainScene;
    appVersionInfo = "-";

    throwToReport = null;
    Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler() {
      public void uncaughtException(Thread p0, Throwable p1) {
        if (throwToReport == null) {
          throwToReport = p1;

          Platform.runLater(new Runnable() {
            public void run() {
              boolean relayToCommandContainer = true;
              // known exceptions that are not relayed forward.
              // problems with combo box:
              // com.sun.javafx.scene.control.skin.ComboBoxPopupControl.positionAndShowPopup(ComboBoxPopupControl.java:193)
              if (throwToReport instanceof NullPointerException) {

                if (throwToReport.getStackTrace()[0].toString().contains("ComboBoxPopupControl.positionAndShowPopup")) {
                  appController.logFrmwrkProblem("", "", IOFXCoreReporter.RT, "jdk8 bug - ComboBoxPopupControl.positionAndShowPopup", appController.fullApplicationCrtlState());
                  relayToCommandContainer = false;

                } else if (throwToReport.getStackTrace()[0].toString().contains("PickResultChooser.processOffer")) {
                  appController.logFrmwrkProblem("", "", IOFXCoreReporter.RT, "jdk11 bug - PickResultChooser.processOffer", appController.fullApplicationCrtlState());
                  relayToCommandContainer = false;

                } else if (throwToReport.getStackTrace()[0].toString().contains("TableViewBehaviorBase.activate")) {
                  relayToCommandContainer = false;

                }
              }

              // report exceptions. but only one. and then close container if necessary.
              if (relayToCommandContainer) {
                appController.logAppProblem(FX8Application.class.getName(), "", IOFXCoreReporter.RT, throwToReport, appController.fullApplicationCrtlState());

                String msg = "\n\n\n" + factory.getSystemLabel(userEnv.getLangIndex(), MoWareTranslations.Key.FATA_APPFRMWRK_PROBLEM) + "\n\n\n\n\n\n";
                if (!(factory.isSilentExLogging())) {
                  msg += OFXConsoleHelper.stackTrace2String(throwToReport);
                }
                appController.showBigInformationDialog(msg, new IApplication.DlgRunnable() {
                  public void run(boolean confirmed) {
                    appController.onExitRequested(true);
                  }
                });

              }
              throwToReport = null;

            }
          });
        }
      }
    });


    // MainWindow is not dynamically created
    // so simply create it here
    mainBorder = new FX8MainBorder();

    jmxHelper = new AppJmxRegistration(appBehaviour.getClass().getName(), "LI", "/localinstance", "/localinstance");
    jmxHelper.registerAppTelemetrics(factory, appBehaviour.getClass().getName(), appBehaviour.getShortAppName(), appBehaviour.getApplicationVersion(), IOFXCoreReporter.MoWarePlatform.MOWARE_FX8 + " / " + MoVersion.MOWARE_PLUGIN_VERSION, "local");

    // we need almost everywhere the factory, so hand it over to appCrtl
    // this class provides services regarding the application window
    appController = new ApplicationMDI(factory, this, appBehaviour, jmxHelper, IOFXCoreReporter.MoWarePlatform.MOWARE_FX8);

    mainBorder.getStyleClass().add("smallFont");
    // special JavaFX stuff
    mainScene = new Scene(mainBorder);

    FX8MainBorder.Position pos = mainBorder.loadPosition();
    stage.setScene(mainScene);
    stage.setX(pos.x);
    stage.setY(pos.y);
    stage.setWidth(pos.width);
    stage.setHeight(pos.height);
    stage.show();


    // some wireing ...
    stage.onCloseRequestProperty().set(new EventHandler<WindowEvent>() {
      public void handle(WindowEvent p0) {
        p0.consume();
        if (mainStage.isIconified()) {
          mainStage.setIconified(false);
        }
        appController.onExitRequested(false);
      }
    });

    stage.getScene().setOnKeyPressed(new EventHandler<KeyEvent>() {
      public void handle(KeyEvent p0) {

        if (mainBorder.isInterfaceLocked()) {
          p0.consume();
          return;
        }

        if (!(p0.getEventType().equals(KeyEvent.KEY_PRESSED))) {
          return;
        }

        // check for special keys CRTL ALT
        String source = "" + p0.getSource();
        source = source.toLowerCase();


        // FX8, java 11 problems. :/ scene, and table sources are ok
        // ignore others: we also receive from textfield, grid etc..  java11
        boolean acceptSource = p0.getSource() == getMainStage().getScene() || source.contains("table") || source.contains("combobox") || p0.getCode().equals(KeyCode.INSERT);

        // esc is delivered twice when enabled delegates are present
        EventTarget target = p0.getTarget();
        boolean acceptTarget = true;
        if (p0.getCode().equals(KeyCode.ESCAPE) && (target instanceof TextField || target instanceof AutoCompletePopupField || target instanceof ComboBox || target instanceof DatePatternField || target instanceof TextArea)) {
          acceptTarget = false;
        }


        if (acceptSource && acceptTarget) {

          if (p0.isControlDown() && p0.isAltDown()) {
            if ("F5".equals(p0.getCode().getName().toUpperCase())) {
              p0.consume();
              appController.onKeyPressEvent(new org.modellwerkstatt.dataux.runtime.core.KeyEvent(false, "DBG_GRAPH"));

            } else if ("F6".equals(p0.getCode().getName().toUpperCase())) {
              p0.consume();
              appController.onKeyPressEvent(new org.modellwerkstatt.dataux.runtime.core.KeyEvent(false, "DBG_SESSION"));

            } else if ("F7".equals(p0.getCode().getName().toUpperCase())) {
              p0.consume();
              appController.onKeyPressEvent(new org.modellwerkstatt.dataux.runtime.core.KeyEvent(false, "DBG_LOCKING"));

            }
          } else if (!(p0.isControlDown()) && p0.getCode().getName().length() == 1) {
            // no nothing ... single char hotkeys are only available with crtl down ..
            p0.consume();

          } else if (!(p0.getCode().equals(KeyCode.ALT))) {
            p0.consume();
            appController.onKeyPressEvent(new org.modellwerkstatt.dataux.runtime.core.KeyEvent(p0.isControlDown() || p0.isAltDown(), p0.getCode().getName().toUpperCase()));
          }

        }

      }
    });


    // let app controller do his intialization stuff
    // setup main-menu and status bar etc.
    // all functionality is given by the FX8UIFactory
    systemName = System.getenv("COMPUTERNAME");
    LoginController loginCrtl = new LoginController(factory, IOFXCoreReporter.MoWarePlatform.MOWARE_FX8, systemName, systemName);
    userEnv.setDevice("DESKTOP", "", "" + systemName);
    String msg = loginCrtl.checkLoginPrepareUserEnv(System.getenv("USERNAME"), "", userEnv, appBehaviour);

    factory.getEventBus().setSysInfo("" + IOFXCoreReporter.MoWarePlatform.MOWARE_FX8 + " " + systemName + ": " + appBehaviour.getShortAppName() + " " + appBehaviour.getApplicationVersion());

    if (msg != null) {
      this.showDialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, msg, new IApplication.DlgRunnable() {
        public void run(boolean confirmed) {
          // this is corret, since no App is running here..
          closeApplicationAndExit();
        }
      });

    } else {

      appController.initializeApplication(null, systemName, userEnv, systemName, "");

      tabChangeListener = new ChangeListener<Tab>() {
        public void changed(ObservableValue<? extends Tab> p0, Tab old, Tab newTab) {
          int i = mainBorder.getMainTabPane().getTabs().indexOf(newTab);
          appController.onTabChangeEvent(i);

        }
      };
      mainBorder.getMainTabPane().getSelectionModel().selectedItemProperty().addListener(tabChangeListener);
    }

    if (System.getProperty("fx8forms.pwd") != null) {
      System.err.println("Current WD: '" + new File(".").getCanonicalPath() + "'.");
    }

    String iconName = System.getProperty("fx8forms.icon");
    if (iconName != null) {
      FileInputStream fi = new FileInputStream(iconName);
      Image img = new Image(fi);
      stage.getIcons().add(img);
      fi.close();
    }


    // css styling ..
    Application.setUserAgentStylesheet(null);
    // file:/Users/danielstieger/migration/2020_3/moware/fx8forms/solutions/org.modellwerkstatt.fx8forms/jars/richclient/inputRuntimeTest/fx8flatter.css
    StyleManager.getInstance().addUserAgentStylesheet(IConsLoader.class.getResource("/inputRuntimeTest/fx8flatter.css").toExternalForm());
  }



  @Override
  public void setAppInfo(String appName, String version, String dynTitle, int brandingId) {
    appVersionInfo = appName + " " + version;

    String fx8Title = appVersionInfo;
    if (!("".equals(dynTitle))) {
      fx8Title += " - " + dynTitle;
    }
    mainStage.setTitle(fx8Title);
  }

  @Override
  public void stop() throws Exception {
    super.stop();
    if (!(mainStage.isIconified())) {
      mainBorder.savePosition(mainStage);
    }

    try {
      factory.getEventBus().close();

    } catch (Exception ex) {
      // just log to console ..
      ex.printStackTrace();
    }
  }

  public void addTab(IToolkit_CommandContainerUi ui) {
    // ensure it is selected ..
    FX8CmdUiTab t = ((FX8CmdUiTab) ui);

    // TabPane is content
    mainBorder.ensureTabPaneInCenter();

    mainBorder.getMainTabPane().getTabs().add(t.getTab());
    mainBorder.getMainTabPane().getSelectionModel().select(t.getTab());
    // requestFocus() is done by ComandContainer ..
  }

  public void focusTab(IToolkit_CommandContainerUi ui) {

    FX8CmdUiTab t = ((FX8CmdUiTab) ui);
    mainBorder.getMainTabPane().getSelectionModel().select(t.getTab());
  }
  public void ensureTabClosed(IToolkit_CommandContainerUi ui) {

    FX8CmdUiTab t = ((FX8CmdUiTab) ui);
    int i = mainBorder.getMainTabPane().getTabs().indexOf(t.getTab());
    mainBorder.getMainTabPane().getTabs().remove(i);
    t.gcClear();

    mainBorder.getMainTabPane().getTabs().remove(null);

    System.gc();
  }

  public void closeApplicationAndExit() {
    // then remove jmx things.
    jmxHelper.gcClean();
    mainStage.close();
  }

  @Override
  public void showDialog(IToolkit_MainWindow.DlgType type, String information, IApplication.DlgRunnable runnable) {
    FX8MsgBox b = new FX8MsgBox(factory, mainStage, type, userEnv.getLangIndex());
    b.showInformation(information, runnable);
    // do nothing ..
  }

  @Override
  public void showProblemsDialog(List<IOFXProblem> problems, IApplication.DlgRunnable callback) {
    FX8MsgBox b = new FX8MsgBox(factory, mainStage, IToolkit_MainWindow.DlgType.INFO_SMALL, userEnv.getLangIndex());
    b.showProblems(problems, callback);
  }
  public void showGraphDebugger(List<Object> graph, String controllerInfo) {
    FX8MsgBox b = new FX8MsgBox(factory, mainStage, IToolkit_MainWindow.DlgType.INFO_LARGE, -1);
    b.showGraphDebugger(graph, controllerInfo);
  }

  public void addStatusInformation(String info) {
    mainBorder.addLeftText(info);
  }
  public void setToastMessage(String info) {
    if ("-".equals(info)) {
      return;
    }

    mainBorder.addLeftText(info);
    FX8ToastPrompt p = new FX8ToastPrompt(mainStage);
    p.showMessage(info);
  }

  public void lockInterface(boolean val) {
    mainBorder.setLockInterface(val);
  }
  public void setMenuAndInit(int langIndex, Menu startMenu, Menu extraMenu, Menu helpMenu) {
    mainBorder.setMenuAndInit(userEnv.getLangIndex(), startMenu, extraMenu, helpMenu);
    mainBorder.setVersionAndAboutInformation(new EventHandler<ActionEvent>() {
      public void handle(ActionEvent event) {
        String versionInfoGetVersion = VersionInfo.getVersion();
        String versionInfoGetRuntimeVersion = VersionInfo.getRuntimeVersion();


        showDialog(IToolkit_MainWindow.DlgType.INFO_SMALL, appVersionInfo + "\n\n\n\n\n" + factory.getSystemLabel(-1, MoWareTranslations.Key.MOWARE_VERSION) + "\n\nFX8 fat client\nJava Ver. " + versionInfoGetVersion + "     Java RT Ver. " + versionInfoGetRuntimeVersion + "\nPlatform '" + factory.getPlatform().getPlatformName() + "'", null);

      }
    }, new EventHandler<ActionEvent>() {
      public void handle(ActionEvent event) {
        appController.onExitRequested(false);
      }
    });
  }

  public void showTiles(List<TileAction> tiles) {
    mainBorder.setOrUpdateTiles(tiles);
  }

  public void setCurrentTabModal(boolean lock) {
    TabPane pane = mainBorder.getMainTabPane();
    ObservableList<Tab> tabs = pane.getTabs();
    int lastTabIndex = tabs.size() - 1;

    if (lock) {
      for (int i = 0; i < lastTabIndex; i++) {
        tabs.get(i).setDisable(true);
      }
      pane.getStyleClass().add(FX8TABCONTENTSTYLECLASS);
      mainBorder.lockMenu(true);

    } else {
      if (lastTabIndex >= 0) {
        pane.getStyleClass().remove(FX8TABCONTENTSTYLECLASS);
        // Just to be sure we have every tab.
        for (int i = 0; i <= lastTabIndex; i++) {
          tabs.get(i).setDisable(false);
        }
      }
      mainBorder.lockMenu(false);
    }
  }

  public void ensureHotkeyAvailable(List<String> hotkeys) {
    // Dummy, not needed in Fx8
  }

  public void execEventInForeground(final ICommandContainer sender, final UxEvent ev) {
    Platform.runLater(new Runnable() {
      public void run() {
        // in ui thread anyway, we do not expect any exceptions
        sender.receiveAndProcess(ev);
      }
    });
  }
  public void execEventInBackground(final ICommandContainer sender, final Runnable runnable) {
    Task<Object> backgroundTask = new Task<Object>() {

      protected Object call() throws Exception {
        try {
          runnable.run();

          Platform.runLater(new Runnable() {
            public void run() {
              lockInterface(false);
              sender.processPendingEvents();
            }
          });

        } catch (final Throwable t) {
          Platform.runLater(new Runnable() {
            public void run() {
              lockInterface(false);
              sender.receiveAndProcess(new CloseCntrExInfoEvent(new RuntimeException("FX8_CmdContainer_BG_Task", t)));
              sender.processPendingEvents();
            }
          });
        }
        return null;
      }


    };


    Thread t = new Thread(backgroundTask);
    t.setDaemon(true);
    t.setName("FX8_CmdContainer_BG_Task");
    this.lockInterface(true);
    t.start();
  }

  public boolean inUiThread() {
    return Platform.isFxApplicationThread();
  }

  @Override
  public void parDeploymentForwardNow() {
  }

  public static void createMenuStructure(ObservableList<MenuItem> items, Menu folder, boolean contextMenu) {
    List<AbstractAction> confs = folder.getAllItems();

    for (AbstractAction currentItem : confs) {
      if (currentItem instanceof CmdAction) {
        items.add(createActionButton(((CmdAction) currentItem), contextMenu));

      } else {
        // null is a seperator
        if (currentItem.labelText == null) {
          items.add(new SeparatorMenuItem());

        } else {
          // obviously a folder ..
          javafx.scene.control.Menu subMenu = new javafx.scene.control.Menu(currentItem.labelText);
          createMenuStructure(subMenu.getItems(), ((Menu) currentItem), contextMenu);
          items.add(subMenu);

        }

      }
    }
  }

  public static FX8MenuItem createActionButton(final CmdAction action, boolean forContextMenu) {
    final FX8MenuItem thisItem;
    String label = action.labelText;
    if (action.hotKey != null && !("".equals(action.hotKey))) {

      if (FX8Application.FX8_HOTKEY_NEEDS_CRTL(action.hotKey)) {
        label = action.labelText + " (CRTL-" + action.hotKey + ")";
      } else {
        label = action.labelText + " (" + action.hotKey + ")";
      }
    }

    if (action.image != null && !(action.image.equals(""))) {
      Image img;
      img = new Image(FX8UiFactory.getImage(action.image));
      thisItem = new FX8MenuItem(img, label, action.getToolTip());
    } else {
      thisItem = new FX8MenuItem(null, label, action.getToolTip());
    }

    if (forContextMenu) {
      action.attachButton2(thisItem);
    } else {
      action.attachButton1(thisItem);
    }

    thisItem.setOnAction(new EventHandler<ActionEvent>() {
      public void handle(ActionEvent event) {

        if (thisItem.getParentPopup() != null) {
          thisItem.getParentPopup().hide();

        } else if (thisItem.getParentMenu() != null) {
          thisItem.getParentMenu().hide();
        }

        // we have to start the command here ...
        action.startCommand();
      }
    });
    return thisItem;
  }
  public Stage getMainStage() {
    return mainStage;
  }
  public static void run(IGenAppUiModule prov, IOFXApplicationFactory appFactory, UserEnvironmentInformation env) {
    appBehaviour = prov;
    factory = ((FX8UiFactory) appFactory);
    userEnv = env;

    SplashScreen sp = SplashScreen.getSplashScreen();
    if (sp != null) {
      sp.close();
    }

    Application.launch();
  }

}
