package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import javafx.geometry.Pos;
import org.modellwerkstatt.objectflow.runtime.OFXConclusionInformation;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;
import org.modellwerkstatt.dataux.runtime.core.ConclusionEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.KeyCode;
import javafx.application.Platform;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.scene.image.PixelWriter;
import javafx.scene.paint.Color;

public class FX8CmdUiBasis extends BorderPane {
  private static String CONCLUCION_BUTTON_BOX = "FX8ConclusionButtonsBox";

  protected HBox rightbuttonBoxPane;
  protected HBox leftbuttonBoxPane;

  protected ICommandContainer commandContainer;
  protected List<FX8Button> conclusionButtons;
  protected BorderPane buttonBorder;
  protected BorderPane colorPane;
  protected FX8NotificationPane notificationPane;

  public FX8CmdUiBasis() {
    conclusionButtons = ListSequence.fromList(new ArrayList<FX8Button>());
    notificationPane = new FX8NotificationPane();
    rightbuttonBoxPane = new HBox();
    leftbuttonBoxPane = new HBox();
    rightbuttonBoxPane.getStyleClass().add(CONCLUCION_BUTTON_BOX);
    leftbuttonBoxPane.getStyleClass().add(CONCLUCION_BUTTON_BOX);
    rightbuttonBoxPane.setAlignment(Pos.CENTER_RIGHT);
    leftbuttonBoxPane.setAlignment(Pos.CENTER_LEFT);
    rightbuttonBoxPane.spacingProperty().set(10.0);
    leftbuttonBoxPane.spacingProperty().set(10.0);

    buttonBorder = new BorderPane();
    buttonBorder.setRight(rightbuttonBoxPane);
    buttonBorder.setLeft(leftbuttonBoxPane);

    notificationPane.onClose(new Runnable() {
      public void run() {
        colorPane.setTop(null);
      }
    });
    this.setBottom(buttonBorder);

    colorPane = new BorderPane();
    this.setTop(colorPane);

  }

  public void gcClear() {
    commandContainer = null;

    ListSequence.fromList(conclusionButtons).visitAll((it) -> {
      it.setOnAction(null);
      it.setOnKeyPressed(null);
    });
    ListSequence.fromList(conclusionButtons).clear();
    conclusionButtons = null;
  }

  public void setCommandContainer(ICommandContainer cmdContainer) {
    commandContainer = cmdContainer;
  }

  public void setConclusions(List<OFXConclusionInformation> conclusionInformations, List<String> additionalHotkeys) {
    // ignore additionalHotKey in FX8
    rightbuttonBoxPane.getChildren().clear();
    leftbuttonBoxPane.getChildren().clear();
    ListSequence.fromList(conclusionButtons).visitAll((it) -> it.setOnAction(null));
    ListSequence.fromList(conclusionButtons).visitAll((it) -> it.setOnKeyPressed(null));
    ListSequence.fromList(conclusionButtons).clear();

    // okay, now then, install the buttons ...
    for (int i = 0; i < conclusionInformations.size(); i++) {
      final OFXConclusionInformation it = conclusionInformations.get(i);

      if (!("".equals(it.hotkey))) {
        it.buttonTitle = it.buttonTitle + " (" + it.hotkey + ")";
      }
      FX8Button newButton = new FX8Button(it.buttonTitle, it.buttonTitle);
      if (!("".equals(it.iconName))) {

        Image img = new Image(FX8UiFactory.getImage(it.iconName));
        ImageView imgView = new ImageView(blackImgWorkaround(img, it.iconName));

        newButton.setGraphic(imgView);
      }
      newButton.setOnAction(new EventHandler<ActionEvent>() {
        public void handle(ActionEvent p0) {
          if (!(isAlreadyClosedAndGcClean())) {
            // hk pressed continously
            commandContainer.receiveAndProcess(new ConclusionEvent(it.conclusionHashCode, it.buttonTitle));
          }
        }
      });


      // before adding, upd button is not visible.
      if ("UPD".equals(it.hotkey)) {
        newButton.setVisible(false);
      }

      if (this instanceof FX8CmdUiPrompt) {
        // enter on button on Tab currently not activated; moware11
        newButton.setOnKeyPressed(new EventHandler<KeyEvent>() {
          public void handle(KeyEvent p0) {
            if (!(isAlreadyClosedAndGcClean()) && p0.getCode().equals(KeyCode.ENTER)) {
              commandContainer.receiveAndProcess(new ConclusionEvent(it.conclusionHashCode, it.buttonTitle));
            }
          }
        });

      }

      ListSequence.fromList(conclusionButtons).addElement(newButton);
      if (i == 0) {
        leftbuttonBoxPane.getChildren().add(newButton);
      } else {
        rightbuttonBoxPane.getChildren().add(newButton);
      }
    }


  }
  public void reevalConclusions(List<OFXConclusionInformation> conclusionInformations) {
    for (int i = 0; i < ListSequence.fromList(conclusionButtons).count(); i++) {
      ListSequence.fromList(conclusionButtons).getElement(i).setItemEnabled(conclusionInformations.get(i).enabled);
    }
  }
  public void setColor(String color) {
    colorPane.setStyle("-fx-border-width: 3 0 0 0; -fx-border-color: " + color + "; -fx-border-insets: 1 0 0 0;");
  }

  public void setNotification(String notificat) {
    notificationPane.setText(notificat);
    colorPane.setTop(notificationPane);
  }

  public boolean isAlreadyClosedAndGcClean() {
    return commandContainer == null;
  }

  public void delayedRequestFocus() {
    // ignored, since delayAfterFullUiInitialized is called by commandContainer ainyway ..
    Platform.runLater(new Runnable() {
      public void run() {
        ((IToolkit_Form) FX8CmdUiBasis.this.getCenter()).myRequestFocus();
      }
    });

  }

  public void delayedAfterFullUiInitialized() {
    Platform.runLater(new Runnable() {
      public void run() {
        ((IToolkit_Form) FX8CmdUiBasis.this.getCenter()).afterFullUiInitialized();
      }
    });
  }

  public static void runRealyLater(final Runnable r) {
    Thread t = new Thread(new Runnable() {
      public void run() {
        try {
          Thread.sleep(1500);
          Platform.runLater(r);
        } catch (InterruptedException ex) {
          ex.printStackTrace();
        }
      }
    });
    t.start();
  }

  public static Image blackImgWorkaround(Image img, String imgName) {
    String[] NO_CONVERT = new String[]{"ok_white", "nopic", "label_white", "autorenew", "arrow_back"};

    boolean found = false;
    for (String candidate : NO_CONVERT) {
      if (candidate.toLowerCase().equals(imgName.toLowerCase())) {
        found = true;
        break;
      }
    }

    if (found) {
      return img;
    } else {
      PixelReader reader = img.getPixelReader();

      int w = (int) img.getWidth();
      int h = (int) img.getHeight();

      WritableImage wImage = new WritableImage(w, h);
      PixelWriter writer = wImage.getPixelWriter();


      for (int y = 0; y < h; y++) {
        for (int x = 0; x < w; x++) {
          Color color = reader.getColor(x, y);
          writer.setColor(x, y, color.invert());
        }
      }
      return wImage;
    }
  }

}
