package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import javafx.stage.Stage;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import javafx.scene.Node;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;

public class FX8CmdUiPrompt extends FX8CmdUiBasis implements IToolkit_CommandContainerUi {
  private FX8Prompt promptWindow;
  private Stage theParentStage;
  private boolean fullScreen;

  public FX8CmdUiPrompt(Stage parentStage, boolean fs) {
    theParentStage = parentStage;
    fullScreen = fs;
  }

  public void show(String windowTitle, IToolkit_Form implementation) {
    // Called by ApplicationController
    // windowTitle is ignored in Prompt Windows
    promptWindow = new FX8Prompt(theParentStage, this, (fullScreen ? FX8Prompt.Size.FULLSSCREEN : FX8Prompt.Size.AUTO_FROMCONTENT));
    // do not adjust high here - not setContent called.
    this.setCenter(((Node) implementation));
    promptWindow.promptScene.setOnKeyPressed(new EventHandler<KeyEvent>() {
      public void handle(KeyEvent p0) {

        // continously hit keys (e.g. f12)
        if (isAlreadyClosedAndGcClean()) {
          return;
        }

        if (!(p0.getEventType().equals(KeyEvent.KEY_PRESSED))) {
          return;
        }

        if (!(p0.isControlDown()) && p0.getCode().getName().length() == 1) {
          // no nothing ... single char hotkeys are only available with crtl down ..
          return;
        }

        boolean forward = false;

        if (p0.getSource() == promptWindow.promptScene) {
          // generally, just take scene hotkeys
          forward = true;

        } else if ((p0.getSource().toString().toLowerCase().contains("tableview") && p0.getCode().equals(KeyCode.ESCAPE))) {
          // escape in tableview is not reported via scene
          forward = true;

        } else if (p0.getCode().equals(KeyCode.INSERT) || p0.getCode().equals(KeyCode.UP) || p0.getCode().equals(KeyCode.DOWN)) {
          // this codes are not reported via scene, but only via textfield... 
          forward = true;
        }

        if (forward) {
          // ignore, we also receive from textfield stuff
          commandContainer.receiveAndProcess(new org.modellwerkstatt.dataux.runtime.core.KeyEvent(p0.isControlDown() || p0.isAltDown(), p0.getCode().getName().toUpperCase()));

        }

        // would it be better to dispatch that event to the application controller first?
      }
    });

    promptWindow.open();
  }

  @Override
  public void setColor(String color) {
    colorPane.setStyle("-fx-border-width: 3 2 2 2; -fx-border-color: " + color + " derive(#2185C5, 50.0%) derive(#2185C5, 50.0%) derive(#2185C5, 50.0%); -fx-border-insets: 0 0 0 0;");

  }
  public void setContent(IToolkit_Form implementation) {
    // Called by CommandContainer
    // BorderPane i guess ..
    BorderPane centerForm = ((BorderPane) implementation);
    this.setCenter(centerForm);
    promptWindow.adjustHeight();
  }

  @Override
  public void adjustWindowTitle(String title) {
    // prompt has no title
  }
  public void close() {
    promptWindow.close();
    gcClear();
  }
  @Override
  public void delayedRequestFocus() {
    promptWindow.adjustHeight();
    super.delayedRequestFocus();
  }

  public boolean isTabWindow() {
    return false;
  }
  public boolean isModalTabWindow() {
    return false;
  }
}
