package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.layout.BorderPane;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DelegateForm;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.utils.LayoutConstraint;
import javafx.scene.layout.GridPane;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.fx8forms.delegates.FX8EditorWithOptions;
import javafx.scene.Node;
import javafx.geometry.HPos;
import javafx.scene.control.TextArea;
import javafx.geometry.VPos;
import javafx.geometry.Insets;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;
import org.modellwerkstatt.fx8forms.delegates.FX8ImageEditor;
import javafx.scene.control.TextField;
import javafx.scene.control.DatePicker;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;

public class FX8DelegateForm<T> extends BorderPane implements IToolkit_DelegateForm<T> {
  private List<LayoutConstraint> colContraints;
  private List<GridPane> colGrindPane;
  private List<IDataUxDelegate> delegates;

  private GridPane gridPane;
  private int curRowIndex;
  private int curColIndex;
  private FX8FlagBox titleLabel;
  private EventHandler<KeyEvent> enterHandler;

  public FX8DelegateForm() {
    super();
    this.getStyleClass().add("FX8DelegateForm");
    colGrindPane = ListSequence.fromList(new ArrayList<GridPane>());
    delegates = ListSequence.fromList(new ArrayList<IDataUxDelegate>());
    curRowIndex = 0;
    curColIndex = 0;


  }

  public void initTitle() {
    titleLabel = new FX8FlagBox();
    BorderPane topPane = new BorderPane();
    topPane.setLeft(titleLabel);
    setTop(topPane);
  }

  public void setTitleText(String text) {
    // check if a title is installed at all ..
    if (getTop() == null) {
      initTitle();
    }
    titleLabel.setTitle(text);

  }
  @Override
  public void rootForm() {
    if (getTop() == null) {
      initTitle();
    }
    titleLabel.inRootForm();
  }

  public void setProblems(List<IOFXProblem> listOfProblems) {
    if (getTop() == null && ListSequence.fromList(listOfProblems).count() == 0) {
      // do not initialize top then, just hang tight .. :)
      return;
    }

    if (getTop() == null) {
      initTitle();
    }

    if (ListSequence.fromList(listOfProblems).count() == 0) {
      // clear flag action
      titleLabel.flag(listOfProblems);
      getCenter().getStyleClass().remove(FX8FormContainer.formFlagBorder);

    } else {
      getCenter().getStyleClass().add(FX8FormContainer.formFlagBorder);
      titleLabel.flag(listOfProblems);
    }

  }


  public void loadList(List<T> objects, IOFXSelection<T> selection) {
  }
  public boolean selectionChanged(IOFXSelection<T> selection) {
    return false;
  }
  public void addDelegate(IDataUxDelegate dlgt) {
    // Column (Spalte),  Row (Zeile)
    // add a column
    ListSequence.fromList(this.delegates).addElement(dlgt);
    IToolkit_TextEditor cmpt = dlgt.getDelegateUiImpl();


    // install ENTER key ..


    if (cmpt instanceof FX8EditorWithOptions && ((FX8EditorWithOptions) cmpt).hasWideOption()) {
      ListSequence.fromList(this.colGrindPane).getElement(curColIndex).add(((Node) cmpt.getRightPartComponent()), 0, curRowIndex, 2, 1);

    } else {
      ListSequence.fromList(this.colGrindPane).getElement(curColIndex).add(((Node) cmpt.getLabel()), 0, curRowIndex);
      GridPane.setHalignment(((Node) cmpt.getLabel()), HPos.RIGHT);
      ListSequence.fromList(this.colGrindPane).getElement(curColIndex).add(((Node) cmpt.getRightPartComponent()), 1, curRowIndex);
    }

    Node editor = ((Node) cmpt.getEditor());
    if (editor instanceof TextArea) {
      GridPane.setValignment(((Node) cmpt.getLabel()), VPos.TOP);
    }

    curColIndex++;
    if (curColIndex >= ListSequence.fromList(this.colGrindPane).count()) {
      curColIndex = 0;
      curRowIndex++;
    }
  }
  public void setColLayoutConstraints(List<String> constraints) {
    this.colContraints = ListSequence.fromList(new ArrayList<LayoutConstraint>());
    this.gridPane = new GridPane();
    this.gridPane.setPadding(new Insets(5, 5, 5, 5));

    ListSequence.fromList(constraints).visitAll((it) -> ListSequence.fromList(FX8DelegateForm.this.colContraints).addElement(new LayoutConstraint(it)));
    final int totalWeight = LayoutConstraint.calcTotalWeight(this.colContraints);
    ListSequence.fromList(this.colContraints).visitAll((it) -> it.setTotalWeight(totalWeight));

    final Wrappers._T<GridPane> newColGridPane = new Wrappers._T<GridPane>();
    final Wrappers._int col = new Wrappers._int(0);
    final boolean usedPxl = ListSequence.fromList(colContraints).any((it) -> it.isPxl());
    ListSequence.fromList(colContraints).visitAll((it) -> {
      // for whole delegate component
      ColumnConstraints colConstrain = new ColumnConstraints();

      // (1) see docu. On pxl use pixl, but for others grow
      // (2) for minimal use nothing
      // (3) for weight use percent, but only when not combined with pxl

      if (it.isPxl()) {
        colConstrain.setPrefWidth(it.getPixl());

      } else if (it.isMinimal()) {
        // nothing - minimal

      } else {
        if (usedPxl) {
          colConstrain.setHgrow(Priority.ALWAYS);

        } else {
          colConstrain.setPercentWidth(it.getInPercent());

        }
      }

      gridPane.getColumnConstraints().add(colConstrain);

      // delegate gridPane
      newColGridPane.value = new GridPane();
      newColGridPane.value.setVgap(5);
      newColGridPane.value.getColumnConstraints().add(new ColumnConstraints());
      ColumnConstraints c2 = new ColumnConstraints();
      c2.setHgrow(Priority.ALWAYS);
      newColGridPane.value.getColumnConstraints().add(c2);
      ListSequence.fromList(colGrindPane).addElement(newColGridPane.value);
      gridPane.add(newColGridPane.value, col.value++, 0);
    });

    this.setCenter(gridPane);
  }


  public void afterFullUiInitialized() {
    for (int i = 0; i < ListSequence.fromList(this.delegates).count(); i++) {
      if (ListSequence.fromList(delegates).getElement(i).getDelegateUiImpl() instanceof FX8ImageEditor) {
        ((FX8ImageEditor) ListSequence.fromList(delegates).getElement(i).getDelegateUiImpl()).adjustImageSize();
      }
    }
  }
  public Object myRequestFocus() {
    // check for readOnly?
    Node focussedNode = null;

    for (int i = 0; i < ListSequence.fromList(this.delegates).count(); i++) {
      if (ListSequence.fromList(delegates).getElement(i).isRequestFocus()) {
        focussedNode = ((Node) ListSequence.fromList(delegates).getElement(i).getDelegateUiImpl().getEditor());
        focussedNode.requestFocus();
        // Demo Test Dan. an aditional selectAll() is necessary for text fields ..
        // Requestfocus behaviour changed .. DAN May 2014
        if (focussedNode instanceof TextField) {
          ((TextField) focussedNode).selectAll();
        } else if (focussedNode instanceof DatePicker) {
          ((DatePicker) focussedNode).getEditor().selectAll();
        }

        break;
      }
    }

    if (focussedNode == null) {
      for (int i = 0; i < ListSequence.fromList(this.delegates).count(); i++) {
        if (ListSequence.fromList(delegates).getElement(i).isEnabled()) {
          focussedNode = ((Node) ListSequence.fromList(delegates).getElement(i).getDelegateUiImpl().getEditor());
          focussedNode.requestFocus();
          // Demo Test Dan. an aditional selectAll() is necessary for text fields ..
          // Requestfocus behaviour changed .. DAN May 2014
          if (focussedNode instanceof TextField) {
            ((TextField) focussedNode).selectAll();
          } else if (focussedNode instanceof DatePicker) {
            ((DatePicker) focussedNode).getEditor().selectAll();
          }

          break;
        }
      }
    }
    return focussedNode;
  }
  public String checkDelegatesValidAndFocus() {
    int focussedOnError = -1;
    String errText;
    String firstErr = null;

    for (int i = 0; i < ListSequence.fromList(this.delegates).count(); i++) {
      errText = ListSequence.fromList(this.delegates).getElement(i).isInputValid();
      if (errText != null && focussedOnError == -1) {
        focussedOnError = i;
        firstErr = errText;
      }
    }


    // focussedOnError is already pre set from method
    // above


    // set focus on error.
    if (focussedOnError != -1) {
      ((Node) ListSequence.fromList(this.delegates).getElement(focussedOnError).getDelegateUiImpl().getEditor()).requestFocus();
    }

    return firstErr;
  }


  public void gcClear() {
    ListSequence.fromList(this.delegates).visitAll(new _FunctionTypes._void_P1_E0<IDataUxDelegate>() {
      public void invoke(IDataUxDelegate it) {
        IToolkit_TextEditor cmpt = it.getDelegateUiImpl();

        // install ENTER key ..
      }
    });


    // gcClear on Delegates is called by IGenControlled
    enterHandler = null;

  }
}
