package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.control.TreeTableView;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import javafx.scene.control.TreeTableColumn;
import javafx.util.Callback;
import javafx.beans.value.ObservableValue;
import org.modellwerkstatt.objectflow.services.MoStringIntroPrinter;

public class FX8GraphDebuggerFactory {
  private FX8TreeItem rootNode;

  public FX8GraphDebuggerFactory() {

  }


  public TreeTableView<String> createGraphAndCrtlInfo(List<Object> graph, String crtlInfo) {
    rootNode = new FX8TreeItem("list<?>");
    rootNode.setExpanded(true);

    for (int i = 0; i < ListSequence.fromList(graph).count(); i++) {
      MoFX8TreeIntroPrinter tip = new MoFX8TreeIntroPrinter(ListSequence.fromList(graph).getElement(i));
      rootNode.addNode(tip.getNodeForObject());
    }

    TreeTableColumn<String, String> col1 = new TreeTableColumn<String, String>("Graph");
    col1.setCellValueFactory(new Callback<TreeTableColumn.CellDataFeatures<String, String>, ObservableValue<String>>() {
      public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<String, String> p) {
        return p.getValue().valueProperty();
      }
    });

    TreeTableColumn<String, String> col2 = new TreeTableColumn<String, String>("Warnings");
    col2.setCellValueFactory(new Callback<TreeTableColumn.CellDataFeatures<String, String>, ObservableValue<String>>() {
      public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<String, String> p) {
        return ((FX8TreeItem) p.getValue()).getWarning();
      }
    });


    TreeTableView<String> ttv = new TreeTableView<String>(rootNode);
    ttv.getColumns().add(col1);
    ttv.getColumns().add(col2);
    col1.prefWidthProperty().bind(ttv.widthProperty().multiply(0.68));
    col2.prefWidthProperty().bind(ttv.widthProperty().multiply(0.28));
    ttv.setShowRoot(true);


    System.err.println("\n\n\n* * * * * * * * *                      FX8 Selection Crtl Info                      * * * * * * * * *\n" + crtlInfo + "\n\n\n");
    return ttv;
  }

  public String createGraphAndCrtlInfoAsString(List<Object> graph, String crtlInfo) {
    StringBuilder sb = new StringBuilder();

    for (int i = 0; i < ListSequence.fromList(graph).count(); i++) {
      MoStringIntroPrinter sip = new MoStringIntroPrinter(ListSequence.fromList(graph).getElement(i));
      sb.append(sip.printGraph());
    }
    sb.append("\n\n\n");
    sb.append(crtlInfo);

    return sb.toString();
  }



}
