package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.layout.StackPane;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.BorderPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.MenuBar;
import javafx.scene.Node;
import javafx.scene.layout.TilePane;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Label;
import javafx.geometry.Orientation;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;
import javafx.scene.control.Tooltip;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import javafx.scene.image.Image;
import javafx.scene.control.SeparatorMenuItem;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.genspecifications.TileAction;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import java.io.File;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import java.util.Properties;
import java.io.FileInputStream;
import java.io.IOException;
import javafx.stage.Stage;
import java.io.FileOutputStream;

public class FX8MainBorder extends StackPane {
  private static String fxPreferencesFile = "MoWareFxPreferences.properties";

  private ProgressIndicator progressIndicator;
  private BorderPane contentArea;
  private TabPane mainTabPane;
  private MenuBar menuBar;
  private Node focussedNodeBeforeLock;

  private TilePane tilePane;

  private MenuItem versionMenuItem;
  private MenuItem quitMenuItem;
  private Label leftLabel;
  private Label rightLabel;



  public FX8MainBorder() {
    super();
    BorderPane statusBar;

    progressIndicator = new ProgressIndicator();
    progressIndicator.setVisible(false);
    progressIndicator.setMaxSize(200.0, 200.0);

    // set up main window
    menuBar = new MenuBar();
    mainTabPane = new TabPane();

    // Status bar ..
    leftLabel = new Label("*");
    rightLabel = new Label("*");
    statusBar = new BorderPane();
    statusBar.setRight(rightLabel);
    statusBar.setLeft(leftLabel);

    contentArea = new BorderPane();
    contentArea.setTop(menuBar);
    contentArea.setBottom(statusBar);

    tilePane = new TilePane();
    tilePane.setOrientation(Orientation.VERTICAL);
    tilePane.vgapProperty().set(10.0);

    tilePane.getStyleClass().add("FX8TilePane");
    contentArea.setCenter(mainTabPane);


    this.getChildren().addAll(progressIndicator, contentArea);
  }

  public void setVersionAndAboutInformation(EventHandler<ActionEvent> versionHandler, EventHandler<ActionEvent> quitHandler) {
    versionMenuItem.setOnAction(versionHandler);
    quitMenuItem.setOnAction(quitHandler);
  }

  public void setLockInterface(boolean lock) {
    if (lock) {
      focussedNodeBeforeLock = this.getScene().getFocusOwner();
    }
    contentArea.setDisable(lock);
    progressIndicator.setVisible(lock);
    if (lock) {
      progressIndicator.toFront();
    } else {
      progressIndicator.toBack();
    }

    if (!(lock) && focussedNodeBeforeLock != null) {
      focussedNodeBeforeLock.requestFocus();
      focussedNodeBeforeLock = null;

    }
  }

  public boolean isInterfaceLocked() {
    return progressIndicator.isVisible();
  }

  public void lockMenu(boolean lock) {
    menuBar.setDisable(lock);
  }

  public void addLeftText(String text) {
    if (!("*".equals(leftLabel.getText()))) {
      String currentTooltip = "";
      Tooltip t = leftLabel.getTooltip();
      if (t != null) {
        currentTooltip = t.getText();
      }
      leftLabel.setTooltip(new Tooltip(currentTooltip + leftLabel.getText() + "\n"));
    }
    leftLabel.setText(text);
  }
  public void setRightText(String text) {
    rightLabel.setText(text);
  }

  public void setMenuAndInit(int langIndex, Menu startFolder, Menu extrasFolder, Menu helpFolder) {
    javafx.scene.control.Menu extraMenu = new javafx.scene.control.Menu(FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.EXTRA));
    javafx.scene.control.Menu startMenu = new javafx.scene.control.Menu(FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.START));
    javafx.scene.control.Menu helpMenu = new javafx.scene.control.Menu(FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.HELP));

    // setup menu
    helpMenu.setMnemonicParsing(true);
    versionMenuItem = new MenuItem(FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.VERSION));
    helpMenu.getItems().add(versionMenuItem);


    menuBar.getMenus().add(startMenu);
    menuBar.getMenus().add(extraMenu);
    menuBar.getMenus().add(helpMenu);

    Image img = new Image(FX8UiFactory.getImage("exit"));
    quitMenuItem = new FX8MenuItem(img, FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.QUIT) + " (ALT-F4)", FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.QUIT) + " (ALT-F4)");

    FX8Application.createMenuStructure(startMenu.getItems(), startFolder, false);
    startMenu.getItems().add(new SeparatorMenuItem());
    startMenu.getItems().add(quitMenuItem);

    FX8Application.createMenuStructure(extraMenu.getItems(), extrasFolder, false);
    FX8Application.createMenuStructure(helpMenu.getItems(), helpFolder, false);
  }

  public void setOrUpdateTiles(List<TileAction> tiles) {

    if (tilePane.getChildren().size() > 0) {
      // update only. take text from labelText
      for (int i = 0; i < tilePane.getChildren().size(); i++) {
        ((FX8TileButton) tilePane.getChildren().get(i)).updateTitle(ListSequence.fromList(tiles).getElement(i).getAction().labelText);
      }

    } else {

      for (TileAction oneTile : tiles) {
        FX8TileButton item = createTileButton(oneTile.getAction(), oneTile.getColor());
        tilePane.getChildren().add(item);
      }
    }
    contentArea.setCenter(tilePane);
  }

  public FX8TileButton createTileButton(final CmdAction action, String color) {
    FX8TileButton thisItem;
    String hotKeyLabel = null;

    if (action.hotKey != null && !("".equals(action.hotKey))) {
      if (FX8Application.FX8_HOTKEY_NEEDS_CRTL(action.hotKey)) {
        hotKeyLabel = "CRTL-" + action.hotKey;

      } else {
        throw new RuntimeException("Tiles accept only hotkeys in form of CRTL-[A-Z]. Hotkey is " + action.hotKey + " which does not need a leading CRTL-?.");
      }
    }

    if (action.image != null && !(action.image.equals(""))) {
      Image img;
      img = new Image(FX8UiFactory.getImage(action.image));
      thisItem = new FX8TileButton(img, action.labelText, action.getToolTip(), hotKeyLabel, color);
    } else {
      thisItem = new FX8TileButton(action.labelText, action.getToolTip(), hotKeyLabel, color);
    }

    action.attachButton1(thisItem);
    thisItem.setOnAction(new EventHandler<ActionEvent>() {
      public void handle(ActionEvent event) {
        // we have to start the command here ...
        action.startCommand();
      }
    });

    return thisItem;
  }
  public void ensureTabPaneInCenter() {
    if (contentArea.getCenter() != mainTabPane) {
      contentArea.setCenter(mainTabPane);
    }
  }
  public TabPane getMainTabPane() {
    return mainTabPane;
  }













  public Position loadPosition() {
    File userHome = new File(System.getProperty("user.home"));
    File propertiesFile = new File(userHome, FX8MainBorder.fxPreferencesFile);
    Position pos = new Position();
    Rectangle2D size = Screen.getPrimary().getBounds();
    pos.x = 50;
    pos.y = 50;
    pos.width = ((int) size.getWidth() - 100);
    pos.height = ((int) size.getHeight() - 100);

    Properties prop = new Properties();
    try {
      // load a properties file
      prop.load(new FileInputStream(propertiesFile));
      // get the property value and print it out
      pos.x = new Integer(prop.getProperty("mainWindowX"));
      pos.y = new Integer(prop.getProperty("mainWindowY"));
      pos.height = new Integer(prop.getProperty("mainWindowHeight"));
      pos.width = new Integer(prop.getProperty("mainWindowWidth"));

    } catch (IOException ex) {
    }

    if (Screen.getScreens().size() == 1) {
      // reset necessary?
      if (pos.x > size.getMaxX() || pos.y > size.getMaxY() || (pos.x + pos.width < 0) || pos.y < 0) {
        // reset
        pos.x = 50;
        pos.y = 50;
        pos.width = ((int) size.getWidth() - 100);
        pos.height = ((int) size.getHeight() - 100);
      }
    }

    return pos;
  }
  public void savePosition(Stage stage) {
    File userHome = new File(System.getProperty("user.home"));
    File propertiesFile = new File(userHome, FX8MainBorder.fxPreferencesFile);

    Position pos = new Position();
    pos.x = ((int) stage.getX());
    pos.y = ((int) stage.getY());
    pos.width = ((int) stage.getWidth());
    pos.height = ((int) stage.getHeight());

    Properties prop = new Properties();
    try {
      // load a properties file
      prop.setProperty("mainWindowX", "" + pos.x);
      prop.setProperty("mainWindowY", "" + pos.y);
      prop.setProperty("mainWindowHeight", "" + pos.height);
      prop.setProperty("mainWindowWidth", "" + pos.width);
      prop.store(new FileOutputStream(propertiesFile), null);


    } catch (IOException ex) {
    }

  }

  public static class Position {
    public int x;
    public int y;
    public int width;
    public int height;
    public Position() {
    }
    @Override
    public String toString() {
      return "x=" + x + " y=" + y + " width=" + width + " height=" + height;
    }
  }

}
