package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.sdservices.ILgcyGraphPrinter;
import org.modellwerkstatt.objectflow.sdservices.LgcyGraphIntrospector;
import org.modellwerkstatt.objectflow.services.IMoTNode;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXDateTime;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXVPBase;

public class MoFX8TreeIntroPrinter implements ILgcyGraphPrinter {
  private LgcyGraphIntrospector introspector;
  private IMoTNode objNode;
  private Object rootObject;

  public MoFX8TreeIntroPrinter(Object rootObj) {
    introspector = new LgcyGraphIntrospector();
    this.rootObject = rootObj;
  }

  public void handleIntro(String indent, String objectName, String simpleFields) {
    objNode = new FX8TreeItem(objectName + "  (" + simpleFields + ")");
  }
  public void handleInteger(String indent, String fieldname, OFXInteger value, boolean isKey) {
    objNode.addNode(fieldname + ": " + value.getValue());
  }
  public void handleBigDecimal(String indent, String fieldname, OFXBigDecimal value, boolean isKey) {
    objNode.addNode(fieldname + ": " + value.getValue());
  }
  public void handleString(String indent, String fieldname, OFXString value, boolean isKey) {
    objNode.addNode(fieldname + ": " + value.getValue());
  }
  public void handleLocalDate(String indent, String fieldname, OFXLocalDate value) {
    objNode.addNode(fieldname + ": " + value.getValue());
  }
  public void handleDateTime(String indent, String fieldname, OFXDateTime value) {
    objNode.addNode(fieldname + ": " + value.getValue());
  }
  public void handleStatus(String indent, String fieldname, OFXStatus ofStatus, boolean isKey) {
    try {
      String longText = "null";
      if (ofStatus.getValue() != null) {
        longText = ofStatus.getValue().getLongDesc();
      }
      objNode.addNode(fieldname + ": " + longText);

    } catch (RuntimeException ex) {
      IMoTNode node = objNode.addNode(fieldname + ": " + ofStatus.getValue());
      node.setWarning("Can not get long Text for value '" + ofStatus.getValue() + "'. Status not known!");
    }
  }

  public void handleKefReference(String indent, String fieldname, OFXKeyReference value) {
    IMoTNode currentRoot = objNode;
    IMoTNode subSection = objNode.addNode(fieldname + " (Reference): Key:" + value.getKey() + "\n");


    if (!(value.getOpposite()) && value.isInitialized()) {
      introspector.introspectionPrint("", value.getValue(), this);
      subSection.addNode(objNode);
    }
    objNode = currentRoot;

  }

  public void handleValueObject(String indent, String fieldname, OFXValueObject value, boolean isKey) {
    IMoTNode currentRoot = objNode;
    IMoTNode subSection = objNode.addNode(fieldname + " (ValueObject): \n");
    // introspect value object
    introspector.introspectionPrint("", value.getValue(), this);
    subSection.addNode(objNode);

    objNode = currentRoot;
  }

  public void handleList(String indent, String fieldname, OFXList value) {
    IMoTNode currentRoot = objNode;

    if (value.getValue() == null) {
      objNode.addNode(fieldname + " (List): NULL !!\n");

    } else {
      IMoTNode subSection = objNode.addNode(fieldname + " (List):\n");
      for (Object obj : value.getValue()) {
        introspector.introspectionPrint("", obj, this);
        subSection.addNode(objNode);
      }
    }

    objNode = currentRoot;
  }

  public void handleVirtualProperty(String indent, String fieldname, OFXVPBase meta, Object value, boolean isKey) {
    objNode.addNode(fieldname + " (Virt.Prop.) " + value + "\n");
  }

  public void handleOutro() {
  }

  public FX8TreeItem getNodeForObject() {
    try {
      introspector.introspectionPrint("", this.rootObject, this);

    } catch (StackOverflowError err) {

      try {
        introspector.noteKeyAndListFieldNames();
        introspector.introspectionPrint("", this.rootObject, this);

      } catch (StackOverflowError provokedError) {
        // ignore
      }
      String allListFieldNames = introspector.getKeyAndListCycleInfo();

      throw new RuntimeException("StackOverflowError - running in cycle on lists/references?\n\n\n" + allListFieldNames + "\n\n\n\n", err);
    }

    return ((FX8TreeItem) objNode);
  }


}
