package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import java.math.BigDecimal;
import javafx.geometry.Pos;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.input.KeyEvent;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.application.Platform;
import javafx.scene.control.TableColumn;

public class XXX___EditingCell<T> extends TableCell<T, Object> {
  private TextField textField;
  private int requested;

  public XXX___EditingCell() {
  }
  @Override
  public void startEdit() {
    if (!(isEmpty())) {
      super.startEdit();
      createTextField();
      setText(null);
      // where are we now ??
      System.err.println("startEdit() setting Graphic() " + this.getIndex());

      setGraphic(textField);
      textField.selectAll();
      textField.requestFocus();
    }
  }
  @Override
  public void cancelEdit() {
    System.err.println("cancelEdit() received");
    super.cancelEdit();
    setText("" + getItem());
    setGraphic(null);
  }

  public boolean commitChanges() {
    try {
      BigDecimal xxx = new BigDecimal(textField.getText());
      System.err.println("commitChanges alost done: object after convert was " + xxx + "(type: " + xxx.getClass().getName() + ")");
      XXX___EditingCell.this.commitEdit(xxx);

      // that results in a updateItem call ...
      System.err.println("commitChanged done ... ");

      return true;
    } catch (Exception ex) {
      return false;
    }

  }

  @Override
  public void updateItem(Object item, boolean empty) {
    // empty is true, if we have a table cell at hand
    // which does not associated with a data item (item=null)
    super.updateItem(item, empty);
    setAlignment(Pos.BASELINE_RIGHT);

    if (empty) {
      setText(null);
      setGraphic(null);
    } else {
      getStyleClass().add("FX8EditingCell");


      if (isEditing()) {
        if (textField != null) {
          textField.setText(getString());
        }
        setText(null);
        setGraphic(textField);
      } else {
        setText(getString());
        setGraphic(null);
      }
    }
  }
  private void createTextField() {
    textField = new TextField(getString());
    textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2);
    textField.focusedProperty().addListener(new ChangeListener<Boolean>() {
      @Override
      public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
        if (!(newValue) && isEditing()) {
          System.err.println("focusPropertyListner() FOCUS lost - canceling editing operation");
          cancelEdit();
        }
      }
    });

    textField.addEventHandler(KeyEvent.KEY_PRESSED, new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {
        if (keyEvent.getCode().equals(KeyCode.ESCAPE)) {
          keyEvent.consume();
          cancelEdit();
        }

        if (keyEvent.getCode().equals(KeyCode.ENTER)) {
          keyEvent.consume();
          adjustPosition(true, 1);
        }

        if (keyEvent.getCode().equals(KeyCode.DOWN)) {
          keyEvent.consume();
          System.err.println(" KEYEVENT: " + keyEvent);
          adjustPosition(true, 1);

        }

        if (keyEvent.getCode().equals(KeyCode.UP)) {
          keyEvent.consume();
          adjustPosition(true, -1);
        }


      }
    });





  }


  public void adjustPosition(boolean commit, int posdiff) {
    boolean okay = true;
    final TablePosition pos = XXX___EditingCell.this.getTableView().getEditingCell();

    if (commit) {
      okay = commitChanges();
    } else {
      cancelEdit();
      okay = false;
    }




    if (okay) {
      // get current index ..
      TableView v = XXX___EditingCell.this.getTableView();


      if (posdiff == 1) {
        v.fireEvent(new KeyEvent(this, v, KeyEvent.KEY_PRESSED, "DOWN", "DOWN", KeyCode.DOWN, false, false, false, false));

      } else {
        v.fireEvent(new KeyEvent(this, v, KeyEvent.KEY_PRESSED, "UP", "UP", KeyCode.UP, false, false, false, false));

      }

      requested = pos.getRow() + posdiff;
      int total = v.getItems().size();

      if (requested >= total || requested < 0) {
        // we r done. FROMER RUNLATER
        Platform.runLater(new Runnable() {
          public void run() {
            XXX___EditingCell.this.getTableView().requestFocus();
          }
        });

      } else {

        System.err.print("Requested is " + requested + "  ");

        Platform.runLater(new Runnable() {
          public void run() {

            TableColumn coloumnPost = XXX___EditingCell.this.getTableView().getColumns().get(pos.getColumn());

            XXX___EditingCell.this.getTableView().edit(requested, coloumnPost);
          }
        });







      }


    }
  }

  private String getString() {
    return (getItem() == null ? "" : "" + getItem());
  }
}
