package org.modellwerkstatt.manmap.conventions;

/*Generated by MPS */


public class ImpExpNameHelper {

  public static String dbIdToJavaId(String dbId, boolean firstUpper) {
    String res = "";

    char current;
    boolean nextBig = false;
    for (int i = 0; i < dbId.length(); i++) {
      current = dbId.charAt(i);
      if (nextBig || (firstUpper && i == 0)) {
        current = Character.toUpperCase(current);
        nextBig = false;
      } else {
        current = Character.toLowerCase(current);
      }

      if (current == '_') {
        nextBig = true;
      } else {
        res += current;
      }

    }

    return res;
  }

  public static String javaIdToDbId(String javaId) {
    String res = "";

    String tmp;
    for (int i = 0; i < javaId.length(); i++) {
      if (i > 0 && Character.isUpperCase(javaId.charAt(i))) {
        tmp = "_" + javaId.charAt(i);
      } else {
        tmp = "" + javaId.charAt(i);
      }
      res += tmp.toUpperCase();
    }

    return res;
  }



  public static void main(String[] args) {
    assert dbIdToJavaId("REF_KEY", false).equals("refKey");
    assert javaIdToDbId("WarenBeleg").equals("WAREN_BELEG");
    assert javaIdToDbId("artikelRef").equals("ARTIKEL_REF");
    System.err.println(javaIdToDbId("ArtikelRef"));
  }

}
