package org.modellwerkstatt.manmap.conventions;

/*Generated by MPS */

import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.manmap.behavior.QueryFromMap__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.IJoinOption__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.IKeyMapping__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.EntityMapping__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.IReferenceMapping__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.ListJoinOption__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.IAtomMapping__BehaviorDescriptor;
import org.modellwerkstatt.manmap.behavior.FieldMapping__BehaviorDescriptor;
import org.jetbrains.mps.openapi.language.SProperty;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;

public class ManmapSQLStatementProvider {
  public ManmapSQLStatementProvider() {
  }

  public static boolean comparePropertyByName(SNode prop, SNode prop2, boolean isKeyOnlyBackRef) {

    String classFqName1 = INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(((SNode) SNodeOperations.getParent(prop)));
    String classFqName2 = INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(((SNode) SNodeOperations.getParent(prop2)));


    if (classFqName1.equals(classFqName2) && SPropertyOperations.getString(prop, PROPS.name$MnvL).equals(SPropertyOperations.getString(prop2, PROPS.name$MnvL))) {
      return true;
    }

    if (isKeyOnlyBackRef) {
      if (SNodeOperations.isInstanceOf(SLinkOperations.getTarget(prop, LINKS.type$56v0), CONCEPTS.ClassifierType$bL) && SNodeOperations.isInstanceOf(SLinkOperations.getTarget(prop2, LINKS.type$56v0), CONCEPTS.ClassifierType$bL)) {
        SNode ct1 = SNodeOperations.cast(SLinkOperations.getTarget(prop, LINKS.type$56v0), CONCEPTS.ClassifierType$bL);
        SNode ct2 = SNodeOperations.cast(SLinkOperations.getTarget(prop2, LINKS.type$56v0), CONCEPTS.ClassifierType$bL);
        if (INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(SLinkOperations.getTarget(ct1, LINKS.classifier$cxMr)).equals(INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(SLinkOperations.getTarget(ct2, LINKS.classifier$cxMr)))) {
          return true;
        }
      } else {
        // primitives have to fit straight...
        String type1 = "" + SNodeOperations.getConcept(SLinkOperations.getTarget(prop, LINKS.type$56v0));
        String type2 = "" + SNodeOperations.getConcept(SLinkOperations.getTarget(prop2, LINKS.type$56v0));
        if (type1.equals(type2)) {
          return true;
        }
      }

    }
    return false;
  }
  private static String keyEqualityForJoinWithObject(String origTableName, List<SNode> objKeys, String refTableName, List<SNode> refFields, final boolean isKeyOnlyBackRef) {
    StringBuilder st = new StringBuilder();

    if (ListSequence.fromList(objKeys).count() != ListSequence.fromList(refFields).count()) {
      throw new IllegalStateException("FATAL: ManmapSQLStatementProvider: in keyEquality - size of lists reference-fields " + refFields + " and referred object keys " + objKeys + " does not match.");
    }


    for (int i = 0; i < ListSequence.fromList(objKeys).count(); i++) {
      final SNode propToMap = SLinkOperations.getTarget(ListSequence.fromList(objKeys).getElement(i), LINKS.property$JxuR);
      st.append(origTableName + "." + SPropertyOperations.getString(SLinkOperations.getTarget(ListSequence.fromList(objKeys).getElement(i), LINKS.fieldName$un98), PROPS.value$w7MM) + " = ");

      SNode fmToMap = ListSequence.fromList(refFields).findFirst((it) -> comparePropertyByName(SLinkOperations.getTarget(it, LINKS.property$JxuR), propToMap, isKeyOnlyBackRef));
      if (fmToMap == null) {

        String msg = "";
        for (SNode fm : refFields) {
          msg += SNodeOperations.present(SNodeOperations.getParent(SLinkOperations.getTarget(fm, LINKS.property$JxuR))) + "." + SLinkOperations.getTarget(fm, LINKS.property$JxuR) + "[" + SLinkOperations.getTarget(SLinkOperations.getTarget(fm, LINKS.property$JxuR), LINKS.type$56v0) + "] ";
        }
        throw new IllegalStateException("Looking to map property " + SNodeOperations.present(SNodeOperations.getParent(propToMap)) + "." + propToMap + "[" + SLinkOperations.getTarget(propToMap, LINKS.type$56v0) + "] but did not find an equivalent to that property in the join mapped ref fields " + msg + ".");
      }
      st.append(refTableName + "." + SPropertyOperations.getString(SLinkOperations.getTarget(fmToMap, LINKS.fieldName$un98), PROPS.value$w7MM));


      if ((i + 1) < ListSequence.fromList(objKeys).count()) {
        st.append(" AND ");
      }
    }

    return st.toString();
  }



  public static List<Integer> getQuerySqlFromStatement(SNode qfm, StringBuilder st, boolean countOnly) {
    SNode jo;
    List<Integer> ilList = ListSequence.fromList(new ArrayList<Integer>());
    int fieldCount = 1;
    ListSequence.fromList(ilList).addElement(1);

    st.append("SELECT ");
    if (countOnly) {
      st.append(" COUNT(*) ");
      ListSequence.fromList(ilList).addElement(1);

    } else {
      // first mapping - base mapping
      fieldCount += ManmapSQLStatementProvider.fieldsForSelect(SLinkOperations.getTarget(qfm, LINKS.entityMapping$Sxke), -1, st);

      // how many fields?
      ListSequence.fromList(ilList).addElement(fieldCount);

      for (int j = 0; j < ListSequence.fromList(QueryFromMap__BehaviorDescriptor.getJoinOptions_id5Wi2c3lUXGB.invoke(qfm)).count(); j++) {
        st.append(", ");

        jo = ListSequence.fromList(QueryFromMap__BehaviorDescriptor.getJoinOptions_id5Wi2c3lUXGB.invoke(qfm)).getElement(j);
        if (SNodeOperations.isInstanceOf(jo, CONCEPTS.ListJoinOption$6l)) {
          fieldCount += ManmapSQLStatementProvider.fieldsForSelect(IJoinOption__BehaviorDescriptor.getEntityMapping_id1NLiuQti4QY.invoke(jo), SNodeOperations.getIndexInParent(jo), st);
          ListSequence.fromList(ilList).addElement(fieldCount);

        } else if (SNodeOperations.isInstanceOf(jo, CONCEPTS.RefJoinOption$hD)) {
          fieldCount += ManmapSQLStatementProvider.fieldsForSelect(IJoinOption__BehaviorDescriptor.getEntityMapping_id1NLiuQti4QY.invoke(jo), SNodeOperations.getIndexInParent(jo), st);
          ListSequence.fromList(ilList).addElement(fieldCount);

        } else {
          throw new IllegalStateException("ManmapSqlStatementProvider: unknown JoinOption - " + SNodeOperations.present(jo));
        }

      }
    }

    // new in M3
    st.append(" FROM %s iRoot");


    // add join statement ..
    String alias;
    for (int j = 0; j < ListSequence.fromList(QueryFromMap__BehaviorDescriptor.getJoinOptions_id5Wi2c3lUXGB.invoke(qfm)).count(); j++) {
      jo = ListSequence.fromList(QueryFromMap__BehaviorDescriptor.getJoinOptions_id5Wi2c3lUXGB.invoke(qfm)).getElement(j);
      alias = IJoinOption__BehaviorDescriptor.getSqlTableAlias_id1H_ywRYwY9P.invoke(jo);

      if (SNodeOperations.isInstanceOf(jo, CONCEPTS.ListJoinOption$6l)) {
        SNode ljo = SNodeOperations.cast(jo, CONCEPTS.ListJoinOption$6l);

        st.append(" LEFT OUTER JOIN %s ");
        // new in M3
        st.append(alias + " ON ");
        st.append(ManmapSQLStatementProvider.keyEqualityForJoinWithObject("iRoot", IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(EntityMapping__BehaviorDescriptor.getIKeyMapping_id3JsUq_Sf9_a.invoke(SLinkOperations.getTarget(qfm, LINKS.entityMapping$Sxke))), alias, IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(IReferenceMapping__BehaviorDescriptor.getRefferedEntityKeyMapping_id4HJH2PnmsZz.invoke(SLinkOperations.getTarget(SLinkOperations.getTarget(ljo, LINKS.listMapping$ZeVJ), LINKS.mappedfieldRef$gS23))), (boolean) ListJoinOption__BehaviorDescriptor.isKeyOnlyBackRefMapping_id6fvTt2jmtat.invoke(ljo)));



      } else if (SNodeOperations.isInstanceOf(jo, CONCEPTS.RefJoinOption$hD)) {
        st.append(" LEFT OUTER JOIN %s ");
        // new in M3
        st.append(alias + " ON ");
        st.append(ManmapSQLStatementProvider.keyEqualityForJoinWithObject(alias, IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(EntityMapping__BehaviorDescriptor.getIKeyMapping_id3JsUq_Sf9_a.invoke(IJoinOption__BehaviorDescriptor.getEntityMapping_id1NLiuQti4QY.invoke(jo))), "iRoot", IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(SLinkOperations.getTarget(SLinkOperations.getTarget(SNodeOperations.cast(jo, CONCEPTS.RefJoinOption$hD), LINKS.refMapping$apx4), LINKS.keyMapping$D3gI)), false));


      } else {
        throw new IllegalStateException("ManmapSqlStatementProvider: unknown JoinOption - " + SNodeOperations.present(jo));
      }

      if ((j + 1) < ListSequence.fromList(QueryFromMap__BehaviorDescriptor.getJoinOptions_id5Wi2c3lUXGB.invoke(qfm)).count()) {
        st.append("  ");
      }
    }

    return ilList;
  }

  public static String getQueryForSingleObject(SNode em) {
    StringBuilder st = new StringBuilder();
    st.append("SELECT ");
    ManmapSQLStatementProvider.fieldsForSelect(em, -1, st);
    // new in M3
    st.append(" FROM %s iRoot WHERE ");


    List<SNode> keys = IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(EntityMapping__BehaviorDescriptor.getIKeyMapping_id3JsUq_Sf9_a.invoke(em));
    for (int i = 0; i < ListSequence.fromList(keys).count(); i++) {
      st.append("iRoot." + SPropertyOperations.getString(SLinkOperations.getTarget(ListSequence.fromList(keys).getElement(i), LINKS.fieldName$un98), PROPS.value$w7MM));
      st.append(" =? ");
      if ((i + 1) < ListSequence.fromList(keys).count()) {
        st.append("AND ");
      }
    }

    return st.toString();
  }
  public static int fieldsForSelect(SNode em, int joinIndex, StringBuilder stFinal) {
    // if index = 0 -> iRoot table !!
    boolean optimisticLock = (boolean) EntityMapping__BehaviorDescriptor.isOptimisticLocked_id17uSheOyWB$.invoke(em);
    int fields;

    StringBuilder st = new StringBuilder();
    fields = ManmapSQLStatementProvider.fieldsFromMapping_insert_1(SLinkOperations.getChildren(em, LINKS.atomMpig$bBsC), st, false, false);

    if (optimisticLock) {
      st.append(", TCN");
      fields++;
    }

    String prefix = "i" + SPropertyOperations.getString(SLinkOperations.getTarget(em, LINKS.classConcept$r5Kr), PROPS.name$MnvL) + "_" + joinIndex + ".";
    // roottable
    if (joinIndex == -1) {
      prefix = "iRoot.";
    }

    String statement = st.toString();
    stFinal.append(prefix + statement.replace(", ", ", " + prefix));



    return fields;
  }
  public static String deleteStatement(SNode em) {
    StringBuilder st = new StringBuilder();

    st.append("DELETE FROM %s WHERE ");
    // new in M3

    List<SNode> fm = IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(EntityMapping__BehaviorDescriptor.getIKeyMapping_id3JsUq_Sf9_a.invoke(em));
    for (int i = 0; i < ListSequence.fromList(fm).count(); i++) {
      st.append(SPropertyOperations.getString(SLinkOperations.getTarget(ListSequence.fromList(fm).getElement(i), LINKS.fieldName$un98), PROPS.value$w7MM));
      st.append(" = ?");
      if ((i + 1) < ListSequence.fromList(fm).count()) {
        st.append(" AND ");
      }
    }

    return st.toString();
  }
  public static String insertStament(SNode em) {
    StringBuilder st = new StringBuilder();
    boolean optimisticLock = (boolean) EntityMapping__BehaviorDescriptor.isOptimisticLocked_id17uSheOyWB$.invoke(em);


    st.append("INSERT INTO %s (");
    // new in M3

    int fieldCount = ManmapSQLStatementProvider.fieldsFromMapping_insert_1(SLinkOperations.getChildren(em, LINKS.atomMpig$bBsC), st, false, false);
    if (optimisticLock) {
      st.append(", TCN) VALUES (");
    } else {
      st.append(") VALUES (");
    }

    for (int i = 0; i < fieldCount; i++) {
      st.append("?");
      if ((i + 1) < fieldCount) {
        st.append(", ");
      }
    }

    if (optimisticLock) {
      st.append(", 0)");
    } else {
      st.append(")");
    }
    return st.toString();
  }
  public static String updateStatement(SNode em) {
    StringBuilder st = new StringBuilder();
    boolean optimisticLock = (boolean) EntityMapping__BehaviorDescriptor.isOptimisticLocked_id17uSheOyWB$.invoke(em);

    st.append("UPDATE %s SET ");
    // new with M3

    ManmapSQLStatementProvider.fieldsFromMapping_insert_1(SLinkOperations.getChildren(em, LINKS.atomMpig$bBsC), st, true, true);

    if (optimisticLock) {
      st.append(", TCN=TCN+1");
    }

    st.append(" WHERE ");

    List<SNode> fm = IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(EntityMapping__BehaviorDescriptor.getIKeyMapping_id3JsUq_Sf9_a.invoke(em));
    for (int j = 0; j < ListSequence.fromList(fm).count(); j++) {
      st.append(SPropertyOperations.getString(SLinkOperations.getTarget(ListSequence.fromList(fm).getElement(j), LINKS.fieldName$un98), PROPS.value$w7MM));
      st.append("=?");
      if ((j + 1) < ListSequence.fromList(fm).count()) {
        st.append(" AND ");
      }
    }

    if (optimisticLock) {
      st.append(" AND TCN=?");
    }

    return st.toString();
  }
  /**
   * -------------------------------------------------------------------------------------------------------------
   * SYNCRONIZE THIS METHOD WITH fieldsFromMapping_insert_1
   * 
   * @param current x
   * @param mappingS x
   * @return x
   */
  public static List<Integer> getKeyIndizes(int current, List<SNode> mappingS, boolean parentWasKey) {
    List<Integer> indizes = ListSequence.fromList(new ArrayList<Integer>());
    SNode mapping;
    int fieldCount = 0;

    for (int i = 0; i < ListSequence.fromList(mappingS).count(); i++) {
      mapping = ListSequence.fromList(mappingS).getElement(i);

      // Dan: 31. March 2016 - only parentWasKey was introduced (and rule check IKeyMapping was changed)
      // parentWasKey: true for a fieldmapping inside a embeddemapping used as key.
      if ((SNodeOperations.isInstanceOf(mapping, CONCEPTS.IKeyMapping$KZ) && (boolean) IKeyMapping__BehaviorDescriptor.isKeyMapping_id3JsUq_Sf9lm.invoke(SNodeOperations.cast(mapping, CONCEPTS.IKeyMapping$KZ))) || parentWasKey) {
        if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.FieldMapping$r8)) {
          ListSequence.fromList(indizes).addElement(current + fieldCount);
          fieldCount++;

        } else if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.EmbeddedMapping$xR)) {
          // recursiveley add ...

          ListSequence.fromList(indizes).addSequence(ListSequence.fromList(ManmapSQLStatementProvider.getKeyIndizes(fieldCount, SLinkOperations.getChildren(SNodeOperations.cast(mapping, CONCEPTS.EmbeddedMapping$xR), LINKS.atomMpig$bBsC), true)));

        }

      } else if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.ReferenceMapping$TY)) {
        for (int j = 0; j < ListSequence.fromList(IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(SLinkOperations.getTarget(SNodeOperations.cast(mapping, CONCEPTS.ReferenceMapping$TY), LINKS.keyMapping$D3gI))).count(); j++) {
          fieldCount++;
        }

      } else if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.IncludeMapping$zh)) {
        ListSequence.fromList(indizes).addSequence(ListSequence.fromList(ManmapSQLStatementProvider.getKeyIndizes(fieldCount, SLinkOperations.getChildren(SLinkOperations.getTarget(SNodeOperations.cast(mapping, CONCEPTS.IncludeMapping$zh), LINKS.mapping$s_SE), LINKS.atomMpig$bBsC), parentWasKey)));

      } else if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.EmbeddedMapping$xR)) {
        // embedd can not contain keys ..
        for (int j = 0; j < ListSequence.fromList(IAtomMapping__BehaviorDescriptor.getFieldMappings_id1H_ywRYtZCm.invoke(SNodeOperations.cast(mapping, CONCEPTS.EmbeddedMapping$xR))).count(); j++) {
          fieldCount++;

        }

      } else if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.FieldMapping$r8)) {
        // Added by Dan in Jan 2012, Bug was a id mapping as second mapping in
        // a mapping description ..
        fieldCount++;

      }



    }

    return indizes;
  }
  /**
   * -------------------------------------------------------------------------------------------------------------
   * SYNCRONIZE THIS METHOD WITH getKeyIndizes !!!!
   * 
   * Only syncronized in case of skippKeysOnUpdate = false
   * 
   * @param mappingS x
   * @param st x
   * @param addQM xx
   * @return x
   */
  public static int fieldsFromMapping_insert_1(List<SNode> mappingS, StringBuilder st, boolean addQM, boolean skippKeysOnUpdate) {
    SNode mapping;
    int fieldCount = 0;

    for (int i = 0; i < ListSequence.fromList(mappingS).count(); i++) {
      mapping = ListSequence.fromList(mappingS).getElement(i);

      if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.FieldMapping$r8)) {
        if (skippKeysOnUpdate && (boolean) FieldMapping__BehaviorDescriptor.isKey_id17uSheOyv7O.invoke(SNodeOperations.cast(mapping, CONCEPTS.FieldMapping$r8))) {
          // skip on update statement ?

        } else {
          if (i > 0 && fieldCount > 0) {
            st.append(", ");
          }

          st.append(SPropertyOperations.getString(SLinkOperations.getTarget(SNodeOperations.cast(mapping, CONCEPTS.FieldMapping$r8), LINKS.fieldName$un98), PROPS.value$w7MM));
          if (addQM) {
            st.append("=?");
          }
          fieldCount++;
        }



      } else if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.ReferenceMapping$TY)) {
        if (i > 0 && fieldCount > 0) {
          st.append(", ");
        }

        for (int j = 0; j < ListSequence.fromList(IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(SLinkOperations.getTarget(SNodeOperations.cast(mapping, CONCEPTS.ReferenceMapping$TY), LINKS.keyMapping$D3gI))).count(); j++) {
          st.append(SPropertyOperations.getString(SLinkOperations.getTarget(ListSequence.fromList(IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(SLinkOperations.getTarget(SNodeOperations.cast(mapping, CONCEPTS.ReferenceMapping$TY), LINKS.keyMapping$D3gI))).getElement(j), LINKS.fieldName$un98), PROPS.value$w7MM));
          if (addQM) {
            st.append("=?");
          }
          fieldCount++;
          if ((j + 1) < ListSequence.fromList(IKeyMapping__BehaviorDescriptor.getKeyFieldMappings_id3JsUq_Sf9k2.invoke(SLinkOperations.getTarget(SNodeOperations.cast(mapping, CONCEPTS.ReferenceMapping$TY), LINKS.keyMapping$D3gI))).count()) {
            st.append(", ");
          }
        }




      } else if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.IncludeMapping$zh)) {
        if (i > 0 && fieldCount > 0) {
          st.append(", ");
        }

        fieldCount += ManmapSQLStatementProvider.fieldsFromMapping_insert_1(SLinkOperations.getChildren(SLinkOperations.getTarget(SNodeOperations.cast(mapping, CONCEPTS.IncludeMapping$zh), LINKS.mapping$s_SE), LINKS.atomMpig$bBsC), st, addQM, skippKeysOnUpdate);

      } else if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.EmbeddedMapping$xR)) {
        if (skippKeysOnUpdate && (boolean) IKeyMapping__BehaviorDescriptor.isKeyMapping_id3JsUq_Sf9lm.invoke(SNodeOperations.cast(mapping, CONCEPTS.EmbeddedMapping$xR))) {
          // skip on update statement ..
        } else {
          if (i > 0 && fieldCount > 0) {
            st.append(", ");
          }
          fieldCount += ManmapSQLStatementProvider.fieldsFromMapping_insert_1(SLinkOperations.getChildren(SNodeOperations.cast(mapping, CONCEPTS.EmbeddedMapping$xR), LINKS.atomMpig$bBsC), st, addQM, skippKeysOnUpdate);
        }

      }



    }

    return fieldCount;
  }


  public static String printFM(List<SNode> mappings) {
    StringBuilder sb = new StringBuilder();
    for (SNode fm : mappings) {
      sb.append(" (FM " + SPropertyOperations.getString(SLinkOperations.getTarget(fm, LINKS.property$JxuR), PROPS.propertyName$DLW4) + ") ");
    }
    return sb.toString();
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
    /*package*/ static final SProperty propertyName$DLW4 = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b75204e4L, "propertyName");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SReferenceLink classifier$cxMr = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier");
    /*package*/ static final SReferenceLink property$JxuR = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e476aafL, "property");
    /*package*/ static final SContainmentLink fieldName$un98 = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e480de7L, "fieldName");
    /*package*/ static final SReferenceLink entityMapping$Sxke = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x7169e080446daebaL, 0x7169e080446daebbL, "entityMapping");
    /*package*/ static final SReferenceLink listMapping$ZeVJ = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x478ffa3d6b619bacL, 0x478ffa3d6b619baeL, "listMapping");
    /*package*/ static final SContainmentLink mappedfieldRef$gS23 = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e48afdaL, 0x6b9f295710412373L, "mappedfieldRef");
    /*package*/ static final SReferenceLink refMapping$apx4 = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x478ffa3d6b62ebc7L, 0x478ffa3d6b62ebc9L, "refMapping");
    /*package*/ static final SContainmentLink keyMapping$D3gI = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x752265f7ae8fe1eeL, 0x752265f7ae905dbaL, "keyMapping");
    /*package*/ static final SContainmentLink atomMpig$bBsC = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e476b28L, 0x3f409dc3f36bdc67L, "atomMpig");
    /*package*/ static final SReferenceLink classConcept$r5Kr = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, 0xc18788c4e4730efL, "classConcept");
    /*package*/ static final SReferenceLink mapping$s_SE = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e5a14fdL, 0xc18788c4e5a1cedL, "mapping");
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept ClassifierType$bL = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, "jetbrains.mps.baseLanguage.structure.ClassifierType");
    /*package*/ static final SConcept ListJoinOption$6l = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x478ffa3d6b619bacL, "org.modellwerkstatt.manmap.structure.ListJoinOption");
    /*package*/ static final SConcept RefJoinOption$hD = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x478ffa3d6b62ebc7L, "org.modellwerkstatt.manmap.structure.RefJoinOption");
    /*package*/ static final SConcept FieldMapping$r8 = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, "org.modellwerkstatt.manmap.structure.FieldMapping");
    /*package*/ static final SConcept EmbeddedMapping$xR = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e476ab6L, "org.modellwerkstatt.manmap.structure.EmbeddedMapping");
    /*package*/ static final SInterfaceConcept IKeyMapping$KZ = MetaAdapterFactory.getInterfaceConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3bdce9a9783c94feL, "org.modellwerkstatt.manmap.structure.IKeyMapping");
    /*package*/ static final SConcept ReferenceMapping$TY = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x752265f7ae8fe1eeL, "org.modellwerkstatt.manmap.structure.ReferenceMapping");
    /*package*/ static final SConcept IncludeMapping$zh = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e5a14fdL, "org.modellwerkstatt.manmap.structure.IncludeMapping");
  }
}
