package org.modellwerkstatt.manmap.conventions;

/*Generated by MPS */

import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import org.modellwerkstatt.manmap.behavior.ICustomSqlStringContentProvider__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.manmap.runtime.MMNamedParameterSupport;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SConceptOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SInterfaceConcept;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.language.SContainmentLink;

public class NamedParameterHelper {


  public static String retrieveContent(SNode nd) {
    if (SNodeOperations.isInstanceOf(nd, CONCEPTS.ICustomSqlStringContentProvider$wd)) {
      return ICustomSqlStringContentProvider__BehaviorDescriptor.getSqlStringContent_idAfw7EvNrEh.invoke(SNodeOperations.cast(nd, CONCEPTS.ICustomSqlStringContentProvider$wd));

    } else if (SNodeOperations.isInstanceOf(nd, CONCEPTS.StringLiteral$xu)) {
      return SPropertyOperations.getString(SNodeOperations.cast(nd, CONCEPTS.StringLiteral$xu), PROPS.value$w7MM);

    } else if (SNodeOperations.isInstanceOf(nd, CONCEPTS.SqlStringFieldRef$3I)) {
      return ICustomSqlStringContentProvider__BehaviorDescriptor.getSqlStringContent_idAfw7EvNrEh.invoke(SLinkOperations.getTarget(SLinkOperations.getTarget(SNodeOperations.cast(nd, CONCEPTS.SqlStringFieldRef$3I), LINKS.sqlstringField$5ZBe), LINKS.sqlString$yWD5));

    } else if (SNodeOperations.isInstanceOf(nd, CONCEPTS.VariableReference$TC)) {
      return retrieveContent(SLinkOperations.getTarget(SLinkOperations.getTarget(SNodeOperations.cast(nd, CONCEPTS.VariableReference$TC), LINKS.variableDeclaration$N1XG), LINKS.initializer$2twD));

    } else if (SNodeOperations.isInstanceOf(nd, CONCEPTS.BinaryOperation$W1)) {
      return retrieveContent(SLinkOperations.getTarget(SNodeOperations.cast(nd, CONCEPTS.BinaryOperation$W1), LINKS.leftExpression$sEj)) + retrieveContent(SLinkOperations.getTarget(SNodeOperations.cast(nd, CONCEPTS.BinaryOperation$W1), LINKS.rightExpression$nvX));

    } else if (SNodeOperations.isInstanceOf(nd, CONCEPTS.DotExpression$yW)) {
      return retrieveContent(SLinkOperations.getTarget(SNodeOperations.cast(nd, CONCEPTS.DotExpression$yW), LINKS.operand$w6IR)) + retrieveContent(SLinkOperations.getTarget(SNodeOperations.cast(nd, CONCEPTS.DotExpression$yW), LINKS.operation$gs9E));

    } else if (SNodeOperations.isInstanceOf(nd, CONCEPTS.InstanceMethodCallOperation$uu)) {
      SNode imco = SNodeOperations.cast(nd, CONCEPTS.InstanceMethodCallOperation$uu);
      String argContent = "";
      for (SNode exp : SLinkOperations.getChildren(imco, LINKS.actualArgument$pzdx)) {
        argContent += retrieveContent(exp);
      }
      return argContent;

    } else if (SNodeOperations.isInstanceOf(nd, CONCEPTS.IOperation$ga)) {
      // ignore any operations
      return "";
    } else if (nd == null) {
      // ignore? 
      return "";
    }

    throw new RuntimeException("Can not analyse sql string. Reformulate it using StringLiterals, sqlStrings, etc. We have a " + SNodeOperations.getConcept(nd).getName() + " here.");
  }
  public static void checkParams(String sql, List<SNode> namedParams) {
    String[] paramNames = new String[ListSequence.fromList(namedParams).count()];
    for (int i = 0; i < ListSequence.fromList(namedParams).count(); i++) {
      paramNames[i] = SPropertyOperations.getString(ListSequence.fromList(namedParams).getElement(i), PROPS.name$MnvL);
    }

    int[] indices = MMNamedParameterSupport.parseSqlStatement(sql, paramNames);
    List<String> remaining = Sequence.fromIterable(Sequence.fromArray(paramNames)).toList();
    for (int idx : indices) {
      String name = paramNames[idx];
      ListSequence.fromList(remaining).removeElement(name);
    }
    if (ListSequence.fromList(remaining).count() != 0) {
      String names = IterableUtils.join(ListSequence.fromList(remaining), ", ");
      throw new RuntimeException("Named parameter(s) " + names + " is not used in sql query.");
    }
  }

  public static void extractNamedParameters(List<SNode> origList, String sql) {

    List<String> paramNamesInSql = MMNamedParameterSupport.retrievFieldsFromSqlStatement(sql);
    paramNamesInSql = ListSequence.fromList(paramNamesInSql).distinct().toList();


    for (final String name : paramNamesInSql) {
      if ((ListSequence.fromList(origList).findFirst((it) -> name.equals(SPropertyOperations.getString(it, PROPS.name$MnvL))) == null)) {
        SNode newNamedPara = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6238a70d306783d0L, "org.modellwerkstatt.manmap.structure.SqlNamedParameter"));
        SPropertyOperations.assign(newNamedPara, PROPS.name$MnvL, name);
        ListSequence.fromList(origList).addElement(newNamedPara);
      }
    }


  }

  private static final class CONCEPTS {
    /*package*/ static final SInterfaceConcept ICustomSqlStringContentProvider$wd = MetaAdapterFactory.getInterfaceConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x98f807a9fcdba85L, "org.modellwerkstatt.manmap.structure.ICustomSqlStringContentProvider");
    /*package*/ static final SConcept StringLiteral$xu = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, "jetbrains.mps.baseLanguage.structure.StringLiteral");
    /*package*/ static final SConcept SqlStringFieldRef$3I = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6ad7cca26edc173L, "org.modellwerkstatt.manmap.structure.SqlStringFieldRef");
    /*package*/ static final SConcept VariableReference$TC = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c77f1e98L, "jetbrains.mps.baseLanguage.structure.VariableReference");
    /*package*/ static final SConcept BinaryOperation$W1 = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xfbdeb6fecfL, "jetbrains.mps.baseLanguage.structure.BinaryOperation");
    /*package*/ static final SConcept DotExpression$yW = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x116b46a08c4L, "jetbrains.mps.baseLanguage.structure.DotExpression");
    /*package*/ static final SConcept InstanceMethodCallOperation$uu = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x118154a6332L, "jetbrains.mps.baseLanguage.structure.InstanceMethodCallOperation");
    /*package*/ static final SInterfaceConcept IOperation$ga = MetaAdapterFactory.getInterfaceConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x116b46ac030L, "jetbrains.mps.baseLanguage.structure.IOperation");
  }

  private static final class PROPS {
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
  }

  private static final class LINKS {
    /*package*/ static final SReferenceLink sqlstringField$5ZBe = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x6ad7cca26edc173L, 0x6ad7cca26edc1c1L, "sqlstringField");
    /*package*/ static final SContainmentLink sqlString$yWD5 = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x1de119beb864396dL, 0x1de119beb8643970L, "sqlString");
    /*package*/ static final SReferenceLink variableDeclaration$N1XG = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c77f1e98L, 0xf8cc6bf960L, "variableDeclaration");
    /*package*/ static final SContainmentLink initializer$2twD = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c37a7f6eL, 0xf8c37f506eL, "initializer");
    /*package*/ static final SContainmentLink leftExpression$sEj = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xfbdeb6fecfL, 0xfbdeb7a11cL, "leftExpression");
    /*package*/ static final SContainmentLink rightExpression$nvX = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xfbdeb6fecfL, 0xfbdeb7a11bL, "rightExpression");
    /*package*/ static final SContainmentLink operation$gs9E = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x116b46a08c4L, 0x116b46b36c4L, "operation");
    /*package*/ static final SContainmentLink operand$w6IR = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x116b46a08c4L, 0x116b46a4416L, "operand");
    /*package*/ static final SContainmentLink actualArgument$pzdx = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x11857355952L, 0xf8c78301aeL, "actualArgument");
  }
}
